/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome;

import com.google.common.base.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.common.entity.mobs.EntityAngler;
import thebetweenlands.common.entity.mobs.EntityBlindCaveFish;
import thebetweenlands.common.entity.mobs.EntityBloodSnail;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityDragonFly;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.entity.mobs.EntityFrog;
import thebetweenlands.common.entity.mobs.EntityGecko;
import thebetweenlands.common.entity.mobs.EntityLeech;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.entity.mobs.EntityMireSnail;
import thebetweenlands.common.entity.mobs.EntitySiltCrab;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.biome.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SwampHagCaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.TreeSpawnEntry;
import thebetweenlands.common.world.gen.biome.decorator.BiomeDecoratorPatchyIslands;
import thebetweenlands.common.world.gen.biome.feature.AlgaeFeature;
import thebetweenlands.common.world.gen.biome.feature.SiltBeachFeature;

public class BiomePatchyIslands
extends BiomeBetweenlands {
    public BiomePatchyIslands() {
        super(new Biome.BiomeProperties("patchy_islands").func_185398_c(118.75f).func_185400_d(4.75f).func_185402_a(1589792).func_185410_a(0.8f).func_185395_b(0.9f));
        this.setWeight(20);
        this.getBiomeGenerator().setDecorator(new BiomeDecoratorPatchyIslands(this)).addFeature(new SiltBeachFeature()).addFeature(new AlgaeFeature());
        this.setFoliageColors(2082413, 2082413);
        BiomeDictionary.registerBiomeType((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }

    @Override
    protected void addSpawnEntries() {
        super.addSpawnEntries();
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityDragonFly.class, 35).setCanSpawnOnWater(true).setGroupSize(1, 2).setSpawnCheckRadius(32.0).setSpawningInterval(400));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFirefly.class, 20).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityMireSnail.class, 60).setGroupSize(1, 5).setSpawnCheckRadius(32.0).setSpawningInterval(800));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFrog.class, 32).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(100));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityBlindCaveFish.class, 30).setCanSpawnInWater(true).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityGecko.class, 40).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(600));
        this.blSpawnEntries.add(new TreeSpawnEntry(EntitySporeling.class, 80).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityLurker.class, 35).setCanSpawnInWater(true).setHostile(true).setSpawnCheckRadius(16.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityAngler.class, 45).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityAngler.class, 35).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntitySwampHag.class, 90).setHostile(true));
        this.blSpawnEntries.add(new SwampHagCaveSpawnEntry(80).setHostile(true).setSpawnCheckRadius(24.0).setGroupSize(1, 3));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityWight.class, 22).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityWight.class, 18).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntitySiltCrab.class, 50).setSurfacePredicate((Predicate<IBlockState>)((Predicate)state -> state.func_177230_c() == BlockRegistry.SILT)).setHostile(true).setGroupSize(2, 8));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityBloodSnail.class, 30).setHostile(true));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityLeech.class, 35).setHostile(true));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityChiromaw.class, 40).setHostile(true).setSpawnCheckRadius(30.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityChiromaw.class, 40).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
    }
}

