/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.entity.mobs.EntityPeatMummy;
import thebetweenlands.common.entity.mobs.EntityPyrad;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.spawning.MobSpawnHandler;
import thebetweenlands.common.world.biome.spawning.spawners.EventSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.LocationSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;
import thebetweenlands.common.world.storage.world.shared.location.EnumLocationType;
import thebetweenlands.util.IWeightProvider;

public class BiomeBetweenlands
extends Biome
implements IWeightProvider {
    protected final List<MobSpawnHandler.BLSpawnEntry> blSpawnEntries = new ArrayList<MobSpawnHandler.BLSpawnEntry>();
    private int grassColor;
    private int foliageColor;
    private short biomeWeight;
    private BiomeGenerator biomeGenerator;
    private int[] fogColorRGB = new int[]{255, 255, 255};

    public BiomeBetweenlands(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.biomeWeight = (short)100;
        this.field_76752_A = BlockRegistry.SWAMP_GRASS.func_176223_P();
        this.field_76753_B = BlockRegistry.SWAMP_DIRT.func_176223_P();
        this.biomeGenerator = new BiomeGenerator(this);
        this.setFogColor(10, 30, 22);
        this.addSpawnEntries();
    }

    protected void addSpawnEntries() {
        this.blSpawnEntries.add(new EventSpawnEntry(new SurfaceSpawnEntry(EntityFirefly.class, 280), "bloodSky").setSpawnCheckRadius(16.0).setGroupSize(1, 4));
        this.blSpawnEntries.add(new EventSpawnEntry(new SurfaceSpawnEntry(EntitySwampHag.class, 250), "bloodSky"){

            @Override
            protected EntityLiving createEntity(World world) {
                EntityLiving entity = super.createEntity(world);
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
                entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
                return entity;
            }
        }.setHostile(true));
        this.blSpawnEntries.add(new EventSpawnEntry(new SurfaceSpawnEntry(EntityPeatMummy.class, 65), "bloodSky"){

            @Override
            protected EntityLiving createEntity(World world) {
                EntityLiving entity = super.createEntity(world);
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27500000298023225);
                entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
                return entity;
            }
        }.setHostile(true).setSpawnCheckRadius(20.0));
        this.blSpawnEntries.add(new LocationSpawnEntry(EntityPyrad.class, 120, EnumLocationType.GIANT_TREE).setHostile(true).setSpawnCheckRadius(26.0).setSpawningInterval(500));
    }

    protected final BiomeBetweenlands setBiomeGenerator(BiomeGenerator generator) {
        if (generator.getBiome() != this) {
            throw new RuntimeException("Generator was assigned to a different biome!");
        }
        this.biomeGenerator = generator;
        return this;
    }

    public final BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    public final List<MobSpawnHandler.BLSpawnEntry> getSpawnEntries() {
        return this.blSpawnEntries;
    }

    protected final BiomeBetweenlands setWeight(int weight) {
        this.biomeWeight = (short)weight;
        return this;
    }

    public final BiomeBetweenlands setFoliageColors(int grassColor, int foliageColor) {
        this.grassColor = grassColor;
        this.foliageColor = foliageColor;
        return this;
    }

    public final BiomeBetweenlands setFogColor(int red, int green, int blue) {
        this.fogColorRGB[0] = red;
        this.fogColorRGB[1] = green;
        this.fogColorRGB[2] = blue;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        if (this.grassColor == 0) {
            return super.func_180627_b(pos);
        }
        return this.grassColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        if (this.foliageColor == 0) {
            return super.func_180625_c(pos);
        }
        return this.foliageColor;
    }

    @Override
    public final short getWeight() {
        return this.biomeWeight;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFogStart(float farPlaneDistance, int mode) {
        return mode == -1 ? 0.0f : farPlaneDistance * 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFogEnd(float farPlaneDistance, int mode) {
        return farPlaneDistance;
    }

    @SideOnly(value=Side.CLIENT)
    public int[] getFogRGB() {
        return this.fogColorRGB;
    }

    public void updateFog() {
    }
}

