/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.misc.Fog;
import thebetweenlands.client.handler.FogHandler;
import thebetweenlands.client.render.sky.BLSkyRenderer;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.event.EnvironmentEventRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeProviderBetweenlands;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.util.config.ConfigHandler;

public class WorldProviderBetweenlands
extends WorldProvider {
    public static final int LAYER_HEIGHT = 120;
    public static final int CAVE_WATER_HEIGHT = 15;
    public static final int PITSTONE_HEIGHT = 45;
    public static final int CAVE_START = 110;
    protected float[] originalLightBrightnessTable = new float[16];
    private boolean allowHostiles;
    private boolean allowAnimals;
    private BetweenlandsWorldData worldData;

    public WorldProviderBetweenlands() {
        this.field_76576_e = true;
    }

    public static final WorldProviderBetweenlands getProvider(World world) {
        if (world != null && world.field_73011_w instanceof WorldProviderBetweenlands) {
            return (WorldProviderBetweenlands)world.field_73011_w;
        }
        return null;
    }

    public boolean func_76567_e() {
        return true;
    }

    public float func_76563_a(long worldTime, float partialTickTime) {
        return 0.35f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        return 0.2f;
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorBetweenlands(this.field_76579_a, this.field_76579_a.func_72905_C(), BlockRegistry.BETWEENSTONE, BlockRegistry.SWAMP_WATER, 120);
    }

    protected void func_76556_a() {
        float minBrightness = (float)((double)1.0E-7f * Math.pow(ConfigHandler.dimensionBrightness, 3.2f) + (double)0.002f);
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)(i * i) / 225.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 6.0f + 1.0f) * (1.0f - minBrightness) + minBrightness;
        }
        System.arraycopy(this.field_76573_f, 0, this.originalLightBrightnessTable, 0, 16);
    }

    public void func_76572_b() {
        this.setDimension(ConfigHandler.dimensionId);
        this.field_76578_c = new BiomeProviderBetweenlands(this.field_76579_a.func_72912_H());
    }

    public boolean func_76569_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public void setAllowedSpawnTypes(boolean allowHostiles, boolean allowAnimals) {
        super.setAllowedSpawnTypes(allowHostiles, allowAnimals);
        this.allowHostiles = allowHostiles;
        this.allowAnimals = allowAnimals;
    }

    public boolean getCanSpawnHostiles() {
        return this.field_76579_a.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean getCanSpawnAnimals() {
        return true;
    }

    public BlockPos getRandomizedSpawnPoint() {
        BlockPos spawnPos = this.field_76579_a.func_175694_M();
        boolean isAdventure = this.field_76579_a.func_72912_H().func_76077_q() == GameType.ADVENTURE;
        int spawnFuzz = 100;
        int spawnFuzzHalf = spawnFuzz / 2;
        if (!isAdventure) {
            spawnPos = spawnPos.func_177982_a(this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf, 0, this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf);
            spawnPos = this.field_76579_a.func_175672_r(spawnPos);
        }
        return spawnPos;
    }

    public BetweenlandsWorldData getWorldData() {
        if (this.worldData == null) {
            this.worldData = BetweenlandsWorldData.forWorld(this.field_76579_a);
        }
        return this.worldData;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public void updateWeather() {
        EnvironmentEventRegistry eeRegistry = this.getWorldData().getEnvironmentEventRegistry();
        this.field_76579_a.func_72912_H().func_76084_b(eeRegistry.HEAVY_RAIN.isActive());
        this.field_76579_a.func_72912_H().func_76069_a(false);
        this.field_76579_a.field_73003_n = this.field_76579_a.field_73004_o;
        if (!this.field_76579_a.field_72995_K) {
            float rainingStrength = this.field_76579_a.field_73004_o;
            if (eeRegistry.HEAVY_RAIN.isActive()) {
                if (rainingStrength < 0.5f) {
                    rainingStrength += 0.0125f;
                }
                if (rainingStrength > 0.5f) {
                    rainingStrength = 0.5f;
                }
            } else {
                if (rainingStrength > 0.0f) {
                    rainingStrength -= 0.0125f;
                }
                if (rainingStrength < 0.0f) {
                    rainingStrength = 0.0f;
                }
            }
            this.field_76579_a.field_73004_o = rainingStrength;
        }
    }

    public void updateLightTable(EntityPlayer player) {
        double diff = Math.max(110.0 - player.field_70163_u, 0.0);
        float multiplier = (float)diff / 110.0f;
        multiplier = 1.0f - multiplier;
        multiplier = (float)((double)multiplier * Math.pow(multiplier, 6.0));
        multiplier = multiplier * 0.9f + 0.1f;
        for (int i = 0; i < 16; ++i) {
            this.field_76573_f[i] = this.originalLightBrightnessTable[i] * (multiplier + (float)Math.pow(i, (1.0f - multiplier) * 2.2f) / 32.0f + multiplier * 0.5f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTickTime) {
        Fog fog = FogHandler.getFogState().getFog(partialTickTime);
        return new Vec3d((double)fog.getRed(), (double)fog.getGreen(), (double)fog.getBlue());
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return BLSkyRenderer.INSTANCE;
    }

    public void calculateInitialWeather() {
        EnvironmentEventRegistry eeRegistry = this.getWorldData().getEnvironmentEventRegistry();
        this.field_76579_a.func_72912_H().func_76084_b(eeRegistry.HEAVY_RAIN.isActive());
        this.field_76579_a.func_72912_H().func_76069_a(false);
        super.calculateInitialWeather();
    }

    public EnvironmentEventRegistry getEnvironmentEventRegistry() {
        return this.getWorldData().getEnvironmentEventRegistry();
    }

    public DimensionType func_186058_p() {
        return TheBetweenlands.dimensionType;
    }
}

