/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile.spawner;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.spawner.MobSpawnerLogicBetweenlands;

public class TileEntityMobSpawnerBetweenlands
extends TileEntity
implements ITickable {
    public float counter = 0.0f;
    public float lastCounter = 0.0f;
    private final MobSpawnerLogicBetweenlands spawnerLogic = new MobSpawnerLogicBetweenlands(){

        @Override
        public void broadcastEvent(int eventID) {
            TileEntityMobSpawnerBetweenlands.this.field_145850_b.func_175641_c(TileEntityMobSpawnerBetweenlands.this.func_174877_v(), BlockRegistry.MOB_SPAWNER, eventID, 0);
        }

        @Override
        public World getSpawnerWorld() {
            return TileEntityMobSpawnerBetweenlands.this.field_145850_b;
        }

        @Override
        public int getSpawnerX() {
            return TileEntityMobSpawnerBetweenlands.this.func_174877_v().func_177958_n();
        }

        @Override
        public int getSpawnerY() {
            return TileEntityMobSpawnerBetweenlands.this.func_174877_v().func_177956_o();
        }

        @Override
        public int getSpawnerZ() {
            return TileEntityMobSpawnerBetweenlands.this.func_174877_v().func_177952_p();
        }

        @Override
        protected void spawnParticles() {
            if (this.getSpawnerWorld().field_73012_v.nextInt(2) == 0) {
                double rx = this.getSpawnerWorld().field_73012_v.nextFloat();
                double ry = this.getSpawnerWorld().field_73012_v.nextFloat();
                double rz = this.getSpawnerWorld().field_73012_v.nextFloat();
                double len = Math.sqrt(rx * rx + ry * ry + rz * rz);
                float counter = -TileEntityMobSpawnerBetweenlands.this.counter;
                BLParticles.SPAWNER.spawn(this.getSpawnerWorld(), (double)this.getSpawnerX() + rx, (double)this.getSpawnerY() + ry, (double)this.getSpawnerZ() + rz, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((rx - 0.5) / len * 0.05, (ry - 0.5) / len * 0.05, (rz - 0.5) / len * 0.05)).withColor(1.0f, MathHelper.func_76131_a((float)(4.0f + (float)Math.sin(counter) * 3.0f), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)((float)Math.sin(counter) * 2.0f), (float)0.0f, (float)1.0f), 0.65f));
            }
        }
    };

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.spawnerLogic.readFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.spawnerLogic.writeToNBT(nbt);
        return nbt;
    }

    public void func_73660_a() {
        this.spawnerLogic.updateSpawner();
        this.lastCounter = this.counter;
        this.counter += 0.0085f;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("entityType", this.getSpawnerLogic().getEntityNameToSpawn());
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (packet.func_148857_g().func_74764_b("entityType")) {
            String entityType = packet.func_148857_g().func_74779_i("entityType");
            this.getSpawnerLogic().setNextEntityName(entityType);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.getSpawnerLogic().writeToNBT(nbt);
        return nbt;
    }

    public boolean func_145842_c(int event, int parameter) {
        return this.spawnerLogic.setDelayToMin(event) || super.func_145842_c(event, parameter);
    }

    public MobSpawnerLogicBetweenlands getSpawnerLogic() {
        return this.spawnerLogic;
    }
}

