/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import thebetweenlands.common.inventory.container.ContainerPurifier;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.purifier.PurifierRecipe;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityPurifier
extends TileEntityBasicInventory
implements IFluidHandler,
ITickable {
    private static final int MAX_TIME = 432;
    public int time = 0;
    public boolean lightOn = false;
    private int prevStackSize = 0;
    private Item prevItem;
    private boolean isPurifyingClient = false;
    public final FluidTank waterTank;
    private final IFluidTankProperties[] properties = new IFluidTankProperties[]{new IFluidTankProperties(){

        public FluidStack getContents() {
            return TileEntityPurifier.this.waterTank.getFluid();
        }

        public int getCapacity() {
            return TileEntityPurifier.this.waterTank.getCapacity();
        }

        public boolean canFill() {
            return TileEntityPurifier.this.waterTank.canFill();
        }

        public boolean canDrain() {
            return TileEntityPurifier.this.waterTank.canDrain();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return TileEntityPurifier.this.waterTank.canFillFluidType(fluidStack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return TileEntityPurifier.this.waterTank.canDrainFluidType(fluidStack);
        }
    }};

    public TileEntityPurifier() {
        super(3, "container.purifier");
        this.waterTank = new FluidTank((Fluid)FluidRegistry.SWAMP_WATER, 0, 16000);
        this.waterTank.setTileEntity((TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        this.lightOn = nbt.func_74767_n("state");
        this.time = nbt.func_74762_e("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("state", this.lightOn);
        nbt.func_74768_a("progress", this.time);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writePacketNbt(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readPacketNbt(packet.func_148857_g());
    }

    protected NBTTagCompound writePacketNbt(NBTTagCompound nbt) {
        nbt.func_74757_a("state", this.lightOn);
        nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("isPurifying", this.isPurifying());
        this.writeInventoryNBT(nbt);
        return nbt;
    }

    protected void readPacketNbt(NBTTagCompound nbt) {
        NBTTagCompound compound = nbt;
        this.lightOn = compound.func_74767_n("state");
        this.waterTank.readFromNBT(compound.func_74775_l("waterTank"));
        this.readInventoryNBT(nbt);
        this.isPurifyingClient = compound.func_74767_n("isPurifying");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.writePacketNbt(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.readPacketNbt(nbt);
    }

    public int getPurifyingProgress() {
        return this.time / 36;
    }

    public boolean isPurifying() {
        return this.time > 0 || this.isPurifyingClient;
    }

    public int getWaterAmount() {
        return this.waterTank.getFluidAmount();
    }

    public int getTanksFullValue() {
        return this.waterTank.getCapacity();
    }

    public int getScaledWaterAmount(int scale) {
        return this.waterTank.getFluid() != null ? (int)((float)this.waterTank.getFluid().amount / (float)this.waterTank.getCapacity() * (float)scale) : 0;
    }

    public void getGUIData(int id, int value) {
        switch (id) {
            case 0: {
                this.time = value;
                break;
            }
            case 1: {
                if (this.waterTank.getFluid() == null) {
                    this.waterTank.setFluid(new FluidStack((Fluid)FluidRegistry.SWAMP_WATER, value));
                    break;
                }
                this.waterTank.getFluid().amount = value;
            }
        }
    }

    public void sendGUIData(ContainerPurifier purifier, IContainerListener craft) {
        craft.func_71112_a((Container)purifier, 0, this.time);
        craft.func_71112_a((Container)purifier, 1, this.waterTank.getFluid() != null ? this.waterTank.getFluid().amount : 0);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack output = PurifierRecipe.getRecipeOutput(this.inventory[1]);
        if (this.hasFuel() && !this.outputIsFull() && (output != null && this.getWaterAmount() > 0 && this.inventory[2] == null || output != null && this.getWaterAmount() > 0 && this.inventory[2] != null && this.inventory[2].func_77969_a(output))) {
            ++this.time;
            if (this.time % 108 == 0) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (SoundEvent)SoundRegistry.PURIFIER, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (!this.lightOn) {
                this.setIlluminated(true);
            }
            if (this.time >= 432) {
                boolean canRun;
                for (int i = 0; i < 2; ++i) {
                    if (this.inventory[i] == null || --this.inventory[i].field_77994_a > 0) continue;
                    this.inventory[i] = null;
                }
                this.extractFluids(new FluidStack((Fluid)FluidRegistry.SWAMP_WATER, 1000));
                if (this.inventory[2] == null) {
                    this.inventory[2] = output.func_77946_l();
                } else if (this.inventory[2].func_77969_a(output)) {
                    this.inventory[2].field_77994_a += output.field_77994_a;
                }
                this.time = 0;
                this.func_70296_d();
                boolean bl = canRun = output != null && this.getWaterAmount() > 0 && this.inventory[2] == null || output != null && this.getWaterAmount() > 0 && this.inventory[2] != null && this.inventory[2].func_77969_a(output);
                if (!canRun) {
                    this.setIlluminated(false);
                }
            }
        }
        if (this.time > 0) {
            this.func_70296_d();
        }
        if (this.func_70301_a(0) == null || this.func_70301_a(1) == null || this.outputIsFull()) {
            this.time = 0;
            this.func_70296_d();
            this.setIlluminated(false);
        }
        if (this.prevStackSize != (this.inventory[2] != null ? this.inventory[2].field_77994_a : 0)) {
            this.func_70296_d();
        }
        if (this.prevItem != (this.inventory[2] != null ? this.inventory[2].func_77973_b() : null)) {
            this.func_70296_d();
        }
        this.prevItem = this.inventory[2] != null ? this.inventory[2].func_77973_b() : null;
        this.prevStackSize = this.inventory[2] != null ? this.inventory[2].field_77994_a : 0;
    }

    private void extractFluids(FluidStack fluid) {
        if (fluid.isFluidEqual(this.waterTank.getFluid())) {
            this.waterTank.drain(fluid.amount, true);
        }
        this.func_70296_d();
    }

    public boolean hasFuel() {
        return this.func_70301_a(0) != null && ItemMisc.EnumItemMisc.SULFUR.isItemOf(this.func_70301_a(0)) && this.func_70301_a((int)0).field_77994_a >= 1;
    }

    private boolean outputIsFull() {
        return this.func_70301_a(2) != null && this.func_70301_a((int)2).field_77994_a >= this.func_70297_j_();
    }

    public void setIlluminated(boolean state) {
        this.lightOn = state;
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, this.lightOn ? 1 : 0);
    }

    public boolean func_145842_c(int eventId, int eventData) {
        switch (eventId) {
            case 0: {
                this.lightOn = eventData == 1;
                this.field_145850_b.func_175664_x(this.field_174879_c);
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return new int[]{2};
        }
        if (facing == EnumFacing.UP) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (doFill) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 3);
        }
        return this.waterTank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (doDrain) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 3);
        }
        return this.waterTank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (doDrain) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 3);
        }
        return this.waterTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

