/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.block.structure.BlockPossessedBlock;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.AnimationMathHelper;

public class TileEntityPossessedBlock
extends TileEntity
implements ITickable {
    public int animationTicks;
    public int coolDown;
    public boolean active;
    AnimationMathHelper headShake = new AnimationMathHelper();
    public float moveProgress;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.findEnemyToAttack();
            if (this.active) {
                this.activateBlock();
                if (this.animationTicks == 0) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.POSSESSED_SCREAM, SoundCategory.BLOCKS, 0.25f, 1.25f - this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
                }
                if (this.animationTicks <= 24) {
                    ++this.animationTicks;
                }
                if (this.animationTicks == 24) {
                    this.setActive(false);
                    this.coolDown = 200;
                }
            }
            if (!this.active) {
                if (this.animationTicks >= 1) {
                    --this.animationTicks;
                }
                if (this.coolDown >= 0) {
                    --this.coolDown;
                }
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        this.moveProgress = 1.0f + this.headShake.swing(4.0f, 1.0f, false);
        if (this.field_145850_b.field_72995_K && !this.active && this.animationTicks % 8 > 0) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockPossessedBlock.FACING);
        float x = 0.0f;
        float z = 0.0f;
        if (facing == EnumFacing.WEST) {
            x = -1.0f;
        }
        if (facing == EnumFacing.EAST) {
            x = 1.0f;
        }
        if (facing == EnumFacing.NORTH) {
            z = -1.0f;
        }
        if (facing == EnumFacing.SOUTH) {
            z = 1.0f;
        }
        float xx = (float)this.func_174877_v().func_177958_n() + 0.5f + x;
        float yy = (float)this.func_174877_v().func_177956_o() + 0.5f;
        float zz = (float)this.func_174877_v().func_177952_p() + 0.5f + z;
        float randomOffset = this.field_145850_b.field_73012_v.nextFloat() * 0.6f - 0.3f;
        BLParticles.SMOKE.spawn(this.field_145850_b, xx - randomOffset, yy + randomOffset, zz + randomOffset);
        BLParticles.SMOKE.spawn(this.field_145850_b, xx + randomOffset, yy - randomOffset, zz + randomOffset);
        BLParticles.SMOKE.spawn(this.field_145850_b, xx + randomOffset, yy + randomOffset, zz - randomOffset);
        BLParticles.SMOKE.spawn(this.field_145850_b, xx + randomOffset, yy - randomOffset, zz + randomOffset);
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    protected Entity findEnemyToAttack() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockPossessedBlock.FACING);
        float x = 0.0f;
        float z = 0.0f;
        if (facing == EnumFacing.WEST) {
            x = -1.25f;
        }
        if (facing == EnumFacing.EAST) {
            x = 1.25f;
        }
        if (facing == EnumFacing.NORTH) {
            z = -1.25f;
        }
        if (facing == EnumFacing.SOUTH) {
            z = 1.25f;
        }
        List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() + x), (double)this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() + z), (double)this.field_174879_c.func_177958_n() + 1.0 + (double)x, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 1.0 + (double)z));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityPlayer) || this.active || this.animationTicks != 0 || this.coolDown > 0) continue;
            this.setActive(true);
        }
        return null;
    }

    protected Entity activateBlock() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockPossessedBlock.FACING);
        float x = 0.0f;
        float z = 0.0f;
        if (facing == EnumFacing.WEST) {
            x = -1.25f;
        }
        if (facing == EnumFacing.EAST) {
            x = 1.25f;
        }
        if (facing == EnumFacing.NORTH) {
            z = -1.25f;
        }
        if (facing == EnumFacing.SOUTH) {
            z = 1.25f;
        }
        List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() + x), (double)this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() + z), (double)this.field_174879_c.func_177958_n() + 1.0 + (double)x, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 1.0 + (double)z));
        if (this.animationTicks == 1) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity == null || !(entity instanceof EntityPlayer)) continue;
                int Knockback = 4;
                entity.func_70024_g((double)(MathHelper.func_76126_a((float)(entity.field_70177_z * 3.141593f / 180.0f)) * (float)Knockback * 0.2f), 0.3, (double)(-MathHelper.func_76134_b((float)(entity.field_70177_z * 3.141593f / 180.0f)) * (float)Knockback * 0.2f));
                ((EntityLivingBase)entity).func_70097_a(DamageSource.field_76377_j, 2.0f);
            }
        }
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("animationTicks", this.animationTicks);
        nbt.func_74757_a("active", this.active);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.animationTicks = nbt.func_74762_e("animationTicks");
        this.active = nbt.func_74767_n("active");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

