/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityLootInventory
extends TileEntityBasicInventory
implements ILootContainer {
    public ResourceLocation lootTable;
    public long lootTableSeed;

    public TileEntityLootInventory(int invtSize, String name) {
        super(invtSize, name);
    }

    public void fillWithLoot(@Nullable EntityPlayer player) {
        if (this.lootTable != null) {
            LootTable lootTable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            Random random = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
            LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                lootBuilder.func_186469_a(player.func_184817_da());
            }
            List loot = lootTable.func_186462_a(random, lootBuilder.func_186471_a());
            ArrayList emptySlots = Lists.newArrayList();
            for (int i = 0; i < this.inventoryHandler.getSlots(); ++i) {
                if (this.inventoryHandler.getStackInSlot(i) != null) continue;
                emptySlots.add(i);
            }
            Collections.shuffle(emptySlots, random);
            ArrayList splittableStacks = Lists.newArrayList();
            Iterator iterator = loot.iterator();
            while (iterator.hasNext()) {
                ItemStack itemstack = (ItemStack)iterator.next();
                if (itemstack.field_77994_a <= 0) {
                    iterator.remove();
                    continue;
                }
                if (itemstack.field_77994_a <= 1) continue;
                splittableStacks.add(itemstack);
                iterator.remove();
            }
            int emptySlotCount = emptySlots.size();
            emptySlotCount = emptySlotCount - loot.size() - splittableStacks.size();
            while (emptySlotCount > 0 && splittableStacks.size() > 0) {
                ItemStack itemstack2 = (ItemStack)splittableStacks.remove(MathHelper.func_76136_a((Random)random, (int)0, (int)(splittableStacks.size() - 1)));
                int i = MathHelper.func_76136_a((Random)random, (int)1, (int)(itemstack2.field_77994_a / 2));
                itemstack2.field_77994_a -= i;
                ItemStack itemstack1 = itemstack2.func_77946_l();
                itemstack1.field_77994_a = i;
                if (--emptySlotCount > 0 && itemstack2.field_77994_a > 1 && random.nextBoolean()) {
                    splittableStacks.add(itemstack2);
                } else {
                    loot.add(itemstack2);
                }
                if (emptySlotCount > 0 && itemstack1.field_77994_a > 1 && random.nextBoolean()) {
                    splittableStacks.add(itemstack1);
                    continue;
                }
                loot.add(itemstack1);
            }
            loot.addAll(splittableStacks);
            Collections.shuffle(loot, random);
            for (ItemStack itemstack : loot) {
                if (itemstack != null && emptySlots.isEmpty()) {
                    System.out.println("Tried to over-fill a container");
                    return;
                }
                if (itemstack == null) {
                    this.inventoryHandler.setStackInSlot(((Integer)emptySlots.remove(emptySlots.size() - 1)).intValue(), (ItemStack)null);
                    continue;
                }
                this.inventoryHandler.setStackInSlot(((Integer)emptySlots.remove(emptySlots.size() - 1)).intValue(), itemstack);
            }
        }
    }

    public void setLootTable(ResourceLocation lootTable, long lootTableSeed) {
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
    }

    public ResourceLocation func_184276_b() {
        return this.lootTable;
    }

    @Override
    protected void writeInventoryNBT(NBTTagCompound nbt) {
        if (!this.checkLootAndWrite(nbt)) {
            super.writeInventoryNBT(nbt);
        }
    }

    @Override
    protected void readInventoryNBT(NBTTagCompound nbt) {
        if (!this.checkLootAndRead(nbt)) {
            super.readInventoryNBT(nbt);
        }
    }

    protected boolean checkLootAndRead(NBTTagCompound compound) {
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean checkLootAndWrite(NBTTagCompound compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void accessSlot(int slot) {
        this.fillWithLoot(null);
    }

    @Override
    public void func_174888_l() {
        this.fillWithLoot(null);
        super.func_174888_l();
    }
}

