/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.recipes.IDruidAltarRecipe;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.container.BlockDruidAltar;
import thebetweenlands.common.block.structure.BlockDruidStone;
import thebetweenlands.common.block.structure.BlockMobSpawnerBetweenlands;
import thebetweenlands.common.entity.mobs.EntityDarkDruid;
import thebetweenlands.common.network.clientbound.MessageDruidAltarProgress;
import thebetweenlands.common.recipe.misc.DruidAltarRecipe;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;
import thebetweenlands.common.tile.spawner.MobSpawnerLogicBetweenlands;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.location.LocationGuarded;

public class TileEntityDruidAltar
extends TileEntityBasicInventory
implements ITickable {
    public static final double FINAL_HEIGHT = 2.0;
    public static final int CRAFTING_TIME = 285;
    private static final float ROTATION_SPEED = 2.0f;
    public float rotation;
    public float prevRotation;
    public float renderYOffset;
    public float prevRenderYOffset;
    public int craftingProgress = 0;
    private boolean circleShouldRevert = true;

    public TileEntityDruidAltar() {
        super(5, "druid_altar");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.circleShouldRevert) {
            this.checkDruidCircleBlocks(this.field_145850_b);
            this.circleShouldRevert = false;
        }
        if (this.field_145850_b.field_72995_K) {
            this.prevRotation = this.rotation;
            this.rotation += 2.0f;
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
            if (this.craftingProgress != 0) {
                ++this.craftingProgress;
            }
            this.prevRenderYOffset = this.renderYOffset;
            this.renderYOffset = (float)((double)this.craftingProgress / 285.0 * 1.8 + 1.2);
        } else if (this.craftingProgress != 0) {
            IDruidAltarRecipe recipe = DruidAltarRecipe.getOutput(this.inventory[1], this.inventory[2], this.inventory[3], this.inventory[4]);
            if (this.craftingProgress % 20 == 0 || this.craftingProgress == 1) {
                this.sendCraftingProgressPacket();
            }
            ++this.craftingProgress;
            if (recipe == null || this.inventory[0] != null) {
                this.stopCraftingProcess();
            }
            if (this.craftingProgress >= 285 && recipe != null) {
                ItemStack stack = recipe.getOutput(new ItemStack[]{this.inventory[1], this.inventory[2], this.inventory[3], this.inventory[4]});
                stack.field_77994_a = 1;
                this.func_70299_a(1, null);
                this.func_70299_a(2, null);
                this.func_70299_a(3, null);
                this.func_70299_a(4, null);
                this.func_70299_a(0, stack);
                this.stopCraftingProcess();
                this.removeSpawner();
            }
        }
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    private void removeSpawner() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == BlockRegistry.MOB_SPAWNER) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), this.field_145850_b.func_180494_b((BlockPos)this.field_174879_c).field_76752_A);
        }
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        IDruidAltarRecipe recipe = DruidAltarRecipe.getOutput(this.inventory[1], this.inventory[2], this.inventory[3], this.inventory[4]);
        if (!this.field_145850_b.field_72995_K && recipe != null && stack != null && this.inventory[0] == null && this.craftingProgress == 0) {
            this.startCraftingProcess();
        }
    }

    private void startCraftingProcess() {
        World world = this.field_145850_b;
        int dim = world.field_73011_w.getDimension();
        this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockDruidAltar.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
        this.craftingProgress = 1;
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageDruidAltarProgress(this, -1), new NetworkRegistry.TargetPoint(dim, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageDruidAltarProgress(this, 1), new NetworkRegistry.TargetPoint(dim, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
        this.checkDruidCircleBlocks(world);
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c).func_72314_b(8.0, 6.0, 8.0);
        List druids = this.field_145850_b.func_72872_a(EntityDarkDruid.class, aabb);
        for (EntityDarkDruid druid : druids) {
            druid.func_70097_a(DamageSource.field_76377_j, druid.func_110143_aJ());
        }
        MobSpawnerLogicBetweenlands logic = BlockMobSpawnerBetweenlands.getLogic(this.field_145850_b, this.field_174879_c.func_177977_b());
        if (logic != null) {
            logic.setDelay(305);
        }
    }

    private void stopCraftingProcess() {
        World world = this.field_145850_b;
        int dim = world.field_73011_w.getDimension();
        this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockDruidAltar.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        this.craftingProgress = 0;
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageDruidAltarProgress(this, -2), new NetworkRegistry.TargetPoint(dim, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageDruidAltarProgress(this, 0), new NetworkRegistry.TargetPoint(dim, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
        this.checkDruidCircleBlocks(world);
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(world);
        List<LocationGuarded> locations = worldStorage.getSharedStorageAt(LocationGuarded.class, location -> location.isInside((Vec3i)this.field_174879_c), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
        for (LocationGuarded location2 : locations) {
            if (!"druidAltar".equals(location2.getName())) continue;
            worldStorage.removeSharedStorage(location2);
        }
    }

    public void sendCraftingProgressPacket() {
        World world = this.field_145850_b;
        int dim = world.field_73011_w.getDimension();
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageDruidAltarProgress(this), new NetworkRegistry.TargetPoint(dim, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
    }

    private void checkDruidCircleBlocks(World world) {
        int baseRadius = 6;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int posX = this.field_174879_c.func_177958_n();
        int posY = this.field_174879_c.func_177956_o();
        int posZ = this.field_174879_c.func_177952_p();
        for (int y = 0; y < 6; ++y) {
            for (int x = -baseRadius; x <= baseRadius; ++x) {
                for (int z = -baseRadius; z <= baseRadius; ++z) {
                    int dSq = x * x + z * z;
                    if (Math.round(Math.sqrt(dSq)) > (long)baseRadius) continue;
                    pos.func_181079_c(posX + x, posY + y, posZ + z);
                    IBlockState state = world.func_180495_p((BlockPos)pos);
                    Block block = state.func_177230_c();
                    if (!(block instanceof BlockDruidStone)) continue;
                    if ((this.craftingProgress == 0 || this.circleShouldRevert) && ((Boolean)state.func_177229_b((IProperty)BlockDruidStone.ACTIVE)).booleanValue()) {
                        world.func_180501_a((BlockPos)pos, state.func_177226_a((IProperty)BlockDruidStone.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                        continue;
                    }
                    if (this.craftingProgress != 1 || ((Boolean)state.func_177229_b((IProperty)BlockDruidStone.ACTIVE)).booleanValue()) continue;
                    world.func_180501_a((BlockPos)pos, state.func_177226_a((IProperty)BlockDruidStone.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("craftingProgress", this.craftingProgress);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.craftingProgress = nbt.func_74762_e("craftingProgress");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeInventoryNBT(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readInventoryNBT(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.writeInventoryNBT(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.readInventoryNBT(nbt);
    }
}

