/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import thebetweenlands.api.recipes.ICompostBinRecipe;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.misc.CompostRecipe;

public class TileEntityCompostBin
extends TileEntity
implements ITickable,
ISidedInventory {
    public static final int COMPOST_PER_ITEM = 25;
    public static final int MAX_COMPOST_AMOUNT = 400;
    public static final int MAX_ITEMS = 20;
    public static final float MAX_OPEN = 90.0f;
    public static final float MIN_OPEN = 0.0f;
    public static final float OPEN_SPEED = 10.0f;
    public static final float CLOSE_SPEED = 10.0f;
    private int compostedAmount;
    private int totalCompostAmount;
    private boolean open = false;
    private float lidAngle = 0.0f;
    private ItemStack[] inventory = new ItemStack[20];
    private int[] processes = new int[20];
    private int[] compostAmounts = new int[20];
    private int[] compostTimes = new int[20];

    public static int[] readIntArrayFixedSize(String id, int length, NBTTagCompound compound) {
        int[] array = compound.func_74759_k(id);
        return array.length != length ? new int[length] : array;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void func_73660_a() {
        float f = this.lidAngle = this.open ? Math.min(this.lidAngle + 10.0f, 90.0f) : Math.max(this.lidAngle - 10.0f, 0.0f);
        if (!this.field_145850_b.field_72995_K) {
            int i;
            if (!this.open) {
                for (i = 0; i < this.inventory.length; ++i) {
                    if (this.inventory[i] == null) continue;
                    if (this.processes[i] >= this.compostTimes[i]) {
                        this.compostedAmount += this.compostAmounts[i];
                        this.inventory[i] = null;
                        this.processes[i] = 0;
                        this.compostTimes[i] = 0;
                        this.compostAmounts[i] = 0;
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                        this.func_70296_d();
                        continue;
                    }
                    int n = i;
                    this.processes[n] = this.processes[n] + 1;
                }
            }
            for (i = 1; i < this.inventory.length; ++i) {
                if (this.inventory[i - 1] != null || this.inventory[i] == null) continue;
                this.inventory[i - 1] = this.inventory[i];
                this.inventory[i] = null;
                this.processes[i - 1] = this.processes[i];
                this.processes[i] = 0;
                this.compostAmounts[i - 1] = this.compostAmounts[i];
                this.compostAmounts[i] = 0;
                this.compostTimes[i - 1] = this.compostTimes[i];
                this.compostTimes[i] = 0;
            }
        }
    }

    public boolean removeCompost(int amount) {
        if (this.compostedAmount != 0) {
            if (this.compostedAmount >= amount) {
                this.compostedAmount -= amount;
                this.totalCompostAmount -= amount;
            } else {
                this.compostedAmount = 0;
                this.totalCompostAmount = 0;
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int addItemToBin(ItemStack stack, int compostAmount, int compostTime, boolean doSimulate) {
        int clampedAmount;
        int n = clampedAmount = this.getTotalCompostAmount() + compostAmount <= 400 ? compostAmount : 400 - this.getTotalCompostAmount();
        if (clampedAmount > 0) {
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] != null) continue;
                if (!doSimulate) {
                    this.inventory[i] = stack.func_77946_l();
                    this.inventory[i].field_77994_a = 1;
                    this.compostAmounts[i] = clampedAmount;
                    this.compostTimes[i] = compostTime;
                    this.processes[i] = 0;
                    this.totalCompostAmount += clampedAmount;
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                    this.func_70296_d();
                }
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNbt(nbt);
    }

    protected void readNbt(NBTTagCompound nbt) {
        NBTTagList inventoryTags = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.inventory.length];
        for (int i = 0; i < inventoryTags.func_74745_c(); ++i) {
            NBTTagCompound data = inventoryTags.func_150305_b(i);
            int j = data.func_74771_c("Slot") & 0xFF;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
        this.processes = TileEntityCompostBin.readIntArrayFixedSize("Processes", this.inventory.length, nbt);
        this.compostAmounts = TileEntityCompostBin.readIntArrayFixedSize("CompostAmounts", this.inventory.length, nbt);
        this.compostTimes = TileEntityCompostBin.readIntArrayFixedSize("CompostTimes", this.inventory.length, nbt);
        this.totalCompostAmount = nbt.func_74762_e("TotalCompostAmount");
        this.compostedAmount = nbt.func_74762_e("CompostedAmount");
        this.open = nbt.func_74767_n("Open");
        this.lidAngle = nbt.func_74760_g("LidAngle");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.writeNbt(nbt);
        return nbt;
    }

    protected void writeNbt(NBTTagCompound nbt) {
        NBTTagList inventoryTags = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(data);
            inventoryTags.func_74742_a((NBTBase)data);
        }
        nbt.func_74783_a("Processes", this.processes);
        nbt.func_74783_a("CompostAmounts", this.compostAmounts);
        nbt.func_74783_a("CompostTimes", this.compostTimes);
        nbt.func_74768_a("TotalCompostAmount", this.totalCompostAmount);
        nbt.func_74768_a("CompostedAmount", this.compostedAmount);
        nbt.func_74782_a("Items", (NBTBase)inventoryTags);
        nbt.func_74757_a("Open", this.open);
        nbt.func_74776_a("LidAngle", this.lidAngle);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.writeNbt(nbt);
        return nbt;
    }

    public boolean hasCompostableItems() {
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            return true;
        }
        return false;
    }

    public float getLidAngle(float partialTicks) {
        return this.open ? Math.min(this.lidAngle + 10.0f * partialTicks, 90.0f) : Math.max(this.lidAngle - 10.0f * partialTicks, 0.0f);
    }

    public int getTotalCompostAmount() {
        return this.totalCompostAmount;
    }

    public int getCompostedAmount() {
        return this.compostedAmount;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            int[] slots = new int[20];
            for (int i = 0; i < this.inventory.length; ++i) {
                slots[i] = i;
            }
            return slots;
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{this.inventory.length + 1};
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        ICompostBinRecipe recipe = CompostRecipe.getCompostRecipe(itemStackIn);
        if (recipe == null) {
            return false;
        }
        return recipe != null && this.open && this.inventory[index] != null && itemStackIn != null && direction == EnumFacing.UP && this.addItemToBin(itemStackIn, recipe.getCompostAmount(itemStackIn), recipe.getCompostingTime(itemStackIn), true) == 1;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return this.open && ItemMisc.EnumItemMisc.COMPOST.isItemOf(stack) && direction == EnumFacing.DOWN;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        if (index >= 0 && index < this.func_70302_i_()) {
            return this.inventory[index];
        }
        return null;
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        if (index < this.inventory.length && this.inventory[index] != null) {
            if (this.inventory[index].field_77994_a <= count) {
                ItemStack itemstack = this.inventory[index];
                this.inventory[index] = null;
                this.processes[index] = 0;
                this.compostTimes[index] = 0;
                this.totalCompostAmount -= this.compostAmounts[index];
                this.compostAmounts[index] = 0;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.inventory[index].func_77979_a(count);
            if (this.inventory[index].field_77994_a == 0) {
                this.inventory[index] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        if (this.inventory[index] != null) {
            ItemStack itemstack = this.inventory[index];
            this.processes[index] = 0;
            this.compostTimes[index] = 0;
            this.totalCompostAmount -= this.compostAmounts[index];
            this.compostAmounts[index] = 0;
            this.inventory[index] = null;
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        ICompostBinRecipe recipe;
        if (index < 20 && (recipe = CompostRecipe.getCompostRecipe(stack)) != null) {
            this.addItemToBin(stack, recipe.getCompostAmount(stack), recipe.getCompostingTime(stack), false);
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        ICompostBinRecipe recipe = CompostRecipe.getCompostRecipe(stack);
        if (recipe == null) {
            return false;
        }
        return recipe != null && this.addItemToBin(stack, recipe.getCompostAmount(stack), recipe.getCompostingTime(stack), true) == 1;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.processes[i] = 0;
            this.compostTimes[i] = 0;
            this.compostAmounts[i] = 0;
            this.totalCompostAmount = 0;
            this.inventory[i] = null;
        }
    }

    public String func_70005_c_() {
        return "compost_bin";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

