/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityBasicInventory
extends TileEntity
implements ISidedInventory {
    private final String name;
    protected ItemStack[] inventory;
    protected final ItemStackHandler inventoryHandler;

    public TileEntityBasicInventory(int invtSize, String name) {
        this.inventory = new ItemStack[invtSize];
        this.inventoryHandler = new ItemStackHandler(this.inventory){

            public void setSize(int size) {
                TileEntityBasicInventory.this.inventory = new ItemStack[size];
                this.stacks = TileEntityBasicInventory.this.inventory;
            }

            protected void onContentsChanged(int slot) {
                TileEntityBasicInventory.this.func_70296_d();
            }

            public void setStackInSlot(int slot, ItemStack stack) {
                TileEntityBasicInventory.this.accessSlot(slot);
                super.setStackInSlot(slot, stack);
            }

            public ItemStack getStackInSlot(int slot) {
                TileEntityBasicInventory.this.accessSlot(slot);
                return super.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                TileEntityBasicInventory.this.accessSlot(slot);
                return super.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                TileEntityBasicInventory.this.accessSlot(slot);
                return super.extractItem(slot, amount, simulate);
            }
        };
        this.name = name;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readInventoryNBT(nbt);
    }

    protected void readInventoryNBT(NBTTagCompound nbt) {
        this.func_174888_l();
        if (nbt.func_150297_b("Inventory", 10)) {
            this.inventoryHandler.deserializeNBT(nbt.func_74775_l("Inventory"));
        }
    }

    @MethodsReturnNonnullByDefault
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeInventoryNBT(nbt);
        return nbt;
    }

    protected void writeInventoryNBT(NBTTagCompound nbt) {
        NBTTagCompound inventoryNbt = this.inventoryHandler.serializeNBT();
        nbt.func_74782_a("Inventory", (NBTBase)inventoryNbt);
    }

    public int func_70302_i_() {
        return this.inventoryHandler.getSlots();
    }

    public ItemStack func_70301_a(int slot) {
        this.accessSlot(slot);
        return this.inventoryHandler.getStackInSlot(slot);
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] slots = new int[this.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        this.accessSlot(slot);
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        this.accessSlot(slot);
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public ItemStack func_70298_a(int index, int count) {
        this.accessSlot(index);
        return this.inventoryHandler.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        this.accessSlot(index);
        return this.inventoryHandler.extractItem(index, this.inventoryHandler.getStackInSlot(index) != null ? this.inventoryHandler.getStackInSlot((int)index).field_77994_a : 0, false);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.accessSlot(index);
        this.inventoryHandler.setStackInSlot(index, stack);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventoryHandler.getSlots(); ++i) {
            this.inventoryHandler.setStackInSlot(i, null);
        }
    }

    protected void accessSlot(int slot) {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryHandler;
        }
        return (T)super.getCapability(capability, facing);
    }
}

