/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.common.herblore.Amounts;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.elixir.ElixirRecipe;
import thebetweenlands.common.herblore.elixir.ElixirRecipes;
import thebetweenlands.common.herblore.elixir.effects.ElixirEffect;
import thebetweenlands.common.registries.AspectRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class TileEntityAlembic
extends TileEntity
implements ITickable {
    public static final int DISTILLING_TIME = 4800;
    public static final float AMOUNT_PER_VIAL = Amounts.VIAL;
    public static final float ISOLATION_LOSS_MULTIPLIER = 0.18f;
    private boolean running = false;
    private int progress = 0;
    private ItemStack infusionBucket = null;
    private float producedAmount = 0.0f;
    private float producableAmount = 0.0f;
    private int producableStrength;
    private int producableDuration;
    private ElixirEffect producableElixir = null;
    private List<Aspect> producableItemAspects = new ArrayList<Aspect>();
    private ElixirRecipe recipe = null;
    private int bucketInfusionTime;
    private boolean loadInfusionData = false;

    public void addInfusion(ItemStack bucket) {
        this.infusionBucket = bucket;
        this.loadFromInfusion();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void func_73660_a() {
        if (this.loadInfusionData) {
            this.loadFromInfusion();
            this.loadInfusionData = false;
        }
        if (this.isFull() && !this.hasFinished()) {
            ++this.progress;
            if (!this.field_145850_b.field_72995_K) {
                if (!this.running || this.progress % 20 == 0) {
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                }
                this.running = true;
                if (this.hasFinished()) {
                    this.producedAmount = this.producableAmount;
                }
            }
        } else if (!this.field_145850_b.field_72995_K) {
            if (this.running) {
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
            this.running = false;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.infusionBucket != null) {
            nbt.func_74782_a("infusionBucket", (NBTBase)this.infusionBucket.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74776_a("producedAmount", this.producedAmount);
        nbt.func_74757_a("running", this.running);
        NBTTagList aspectList = new NBTTagList();
        for (Aspect aspect : this.producableItemAspects) {
            NBTTagCompound aspectCompound = new NBTTagCompound();
            aspect.writeToNBT(aspectCompound);
            aspectList.func_74742_a((NBTBase)aspectCompound);
        }
        nbt.func_74782_a("producableItemAspects", (NBTBase)aspectList);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("infusionBucket")) {
            this.infusionBucket = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("infusionBucket"));
        }
        this.loadInfusionData = true;
        this.progress = nbt.func_74762_e("progress");
        this.producedAmount = nbt.func_74760_g("producedAmount");
        this.running = nbt.func_74767_n("running");
        if (nbt.func_74764_b("producableItemAspects")) {
            this.producableItemAspects.clear();
            NBTTagList aspectList = nbt.func_150295_c("producableItemAspects", 10);
            for (int i = 0; i < aspectList.func_74745_c(); ++i) {
                NBTTagCompound aspectCompound = aspectList.func_150305_b(i);
                Aspect aspect = Aspect.readFromNBT(aspectCompound);
                this.producableItemAspects.add(aspect);
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("running", this.running);
        NBTTagCompound itemStackCompound = new NBTTagCompound();
        if (this.infusionBucket != null) {
            this.infusionBucket.func_77955_b(itemStackCompound);
        }
        nbt.func_74782_a("infusionBucket", (NBTBase)itemStackCompound);
        nbt.func_74768_a("progress", this.progress);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.running = packet.func_148857_g().func_74767_n("running");
        NBTTagCompound itemStackCompound = packet.func_148857_g().func_74775_l("infusionBucket");
        ItemStack oldStack = this.infusionBucket;
        this.infusionBucket = itemStackCompound != null && itemStackCompound.func_74765_d("id") != 0 ? ItemStack.func_77949_a((NBTTagCompound)itemStackCompound) : null;
        if (this.infusionBucket != null && !ItemStack.func_77989_b((ItemStack)this.infusionBucket, (ItemStack)oldStack)) {
            this.loadFromInfusion();
        }
        this.progress = packet.func_148857_g().func_74762_e("progress");
    }

    public ElixirRecipe getElixirRecipe() {
        return this.recipe;
    }

    public int getInfusionTime() {
        return this.bucketInfusionTime;
    }

    public float getProgress() {
        return (float)this.progress / 4800.0f;
    }

    private void loadFromInfusion() {
        boolean bl;
        ElixirRecipe recipe;
        int infusionTime;
        this.recipe = null;
        if (this.infusionBucket == null) {
            return;
        }
        this.bucketInfusionTime = infusionTime = this.infusionBucket.func_77978_p().func_74762_e("infusionTime");
        if (!this.infusionBucket.func_77978_p().func_74764_b("ingredients")) {
            this.addInvalidInfusion();
            return;
        }
        NBTTagList nbtList = (NBTTagList)this.infusionBucket.func_77978_p().func_74781_a("ingredients");
        ArrayList<ItemStack> infusionIngredients = new ArrayList<ItemStack>();
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            infusionIngredients.add(ItemStack.func_77949_a((NBTTagCompound)nbtList.func_150305_b(i)));
        }
        List<IAspectType> infusionAspects = this.getInfusionAspects(infusionIngredients);
        this.recipe = recipe = ElixirRecipes.getFromAspects(infusionAspects);
        if (recipe == null || infusionTime < recipe.idealInfusionTime - recipe.infusionTimeVariation || infusionTime > recipe.idealInfusionTime + recipe.infusionTimeVariation) {
            this.addInvalidInfusion();
            return;
        }
        List<Aspect> infusionItemAspects = this.getInfusionItemAspects(infusionIngredients);
        float totalAmount = Amounts.VERY_LOW;
        float strengthAspectAmount = 0.0f;
        float durationAspectAmount = 0.0f;
        for (Aspect aspect : infusionItemAspects) {
            totalAmount += aspect.getDisplayAmount();
            if (recipe.strengthAspect != null && aspect.type == recipe.strengthAspect) {
                strengthAspectAmount += aspect.getDisplayAmount();
            }
            if (recipe.durationAspect == null || aspect.type != recipe.durationAspect) continue;
            durationAspectAmount += aspect.getDisplayAmount();
        }
        int recipeByariis = 0;
        for (IAspectType a : recipe.aspects) {
            if (a != AspectRegistry.BYARIIS) continue;
            ++recipeByariis;
        }
        this.producableAmount = totalAmount;
        boolean bl2 = true;
        for (IAspectType a : infusionAspects) {
            if (a != AspectRegistry.BYARIIS) continue;
            if (recipeByariis <= 0) {
                bl = !bl;
                continue;
            }
            --recipeByariis;
        }
        this.producableElixir = bl ? recipe.positiveElixir : recipe.negativeElixir;
        float relStrengthAmount = strengthAspectAmount / Amounts.MAX_ASPECT_AMOUNT;
        float relDurationAmount = durationAspectAmount / Amounts.MAX_ASPECT_AMOUNT;
        this.producableStrength = MathHelper.func_76141_d((float)(relStrengthAmount * 4.0f));
        this.producableDuration = bl ? recipe.baseDuration + MathHelper.func_76141_d((float)((float)recipe.durationModifier * relDurationAmount * 2.0f)) : recipe.negativeBaseDuration + MathHelper.func_76141_d((float)((float)recipe.negativeDurationModifier * relDurationAmount * 2.0f));
    }

    private void addInvalidInfusion() {
        this.producableElixir = null;
        this.producableAmount = 0.0f;
        this.producableDuration = 0;
        this.producableStrength = 0;
        this.producableItemAspects.clear();
        if (this.infusionBucket != null && this.infusionBucket.func_77978_p() != null && this.infusionBucket.func_77978_p().func_74764_b("ingredients")) {
            NBTTagList nbtList = (NBTTagList)this.infusionBucket.func_77978_p().func_74781_a("ingredients");
            ArrayList<ItemStack> infusionIngredients = new ArrayList<ItemStack>();
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                infusionIngredients.add(ItemStack.func_77949_a((NBTTagCompound)nbtList.func_150305_b(i)));
            }
            List<Aspect> infusionAspects = this.getInfusionItemAspects(infusionIngredients);
            for (Aspect aspect : infusionAspects) {
                this.producableItemAspects.add(new Aspect(aspect.type, (int)(aspect.getDisplayAmount() * 0.18f * 100.0f)));
            }
        }
    }

    public List<IAspectType> getInfusionAspects(List<ItemStack> ingredients) {
        ArrayList<IAspectType> infusingAspects = new ArrayList<IAspectType>();
        for (ItemStack ingredient : ingredients) {
            infusingAspects.addAll(AspectManager.get(this.field_145850_b).getDiscoveredAspectTypes(AspectManager.getAspectItem(ingredient), null));
        }
        return infusingAspects;
    }

    private List<Aspect> getInfusionItemAspects(List<ItemStack> ingredients) {
        ArrayList<Aspect> infusingItemAspects = new ArrayList<Aspect>();
        for (ItemStack ingredient : ingredients) {
            infusingItemAspects.addAll(AspectManager.get(this.field_145850_b).getDiscoveredAspects(AspectManager.getAspectItem(ingredient), null));
        }
        return infusingItemAspects;
    }

    public boolean isFull() {
        return this.infusionBucket != null;
    }

    public boolean hasFinished() {
        return this.progress >= 4800;
    }

    public boolean hasElixir() {
        return this.producedAmount > 0.0f;
    }

    public boolean isRunning() {
        return this.running;
    }

    public ItemStack getElixir(int vialType) {
        if (this.isFull() && this.hasFinished()) {
            if (this.producableElixir != null) {
                ItemStack elixir = null;
                if (this.hasElixir()) {
                    // empty if block
                }
                this.producedAmount -= AMOUNT_PER_VIAL;
                if (this.producedAmount <= 0.0f || !this.hasElixir()) {
                    this.reset();
                }
                return elixir;
            }
            ItemStack aspectVial = null;
            if (this.producableItemAspects.size() >= 1) {
                Aspect aspect = this.producableItemAspects.get(0);
                this.producableItemAspects.remove(0);
                float totalAmount = aspect.getDisplayAmount() * 100.0f;
                Iterator<Aspect> itemAspectIT = this.producableItemAspects.iterator();
                while (itemAspectIT.hasNext()) {
                    Aspect currentAspect = itemAspectIT.next();
                    if (currentAspect.type != aspect.type) continue;
                    totalAmount += currentAspect.getDisplayAmount() * 100.0f;
                    itemAspectIT.remove();
                }
                aspectVial = new ItemStack((Item)ItemRegistry.ASPECT_VIAL, 1, vialType);
                ItemAspectContainer aspectContainer = ItemAspectContainer.fromItem(aspectVial);
                aspectContainer.add(aspect.type, (int)totalAmount);
            }
            if (this.producableItemAspects.size() == 0) {
                this.reset();
            }
            return aspectVial;
        }
        return null;
    }

    public void reset() {
        this.producableItemAspects.clear();
        this.infusionBucket = null;
        this.producableAmount = 0.0f;
        this.producableDuration = 0;
        this.producableElixir = null;
        this.producableStrength = 0;
        this.producedAmount = 0.0f;
        this.progress = 0;
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }
}

