/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import thebetweenlands.api.recipes.IPurifierRecipe;
import thebetweenlands.common.block.terrain.BlockCragrock;
import thebetweenlands.common.block.terrain.BlockDentrothyst;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.entity.rowboat.EntityWeedwoodRowboat;
import thebetweenlands.common.item.equipment.ItemAmulet;
import thebetweenlands.common.item.herblore.ItemCrushed;
import thebetweenlands.common.item.herblore.ItemPlantDrop;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.item.misc.ItemSwampTalisman;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;
import thebetweenlands.common.recipe.misc.CompostRecipe;
import thebetweenlands.common.recipe.misc.DruidAltarRecipe;
import thebetweenlands.common.recipe.misc.PestleAndMortarRecipe;
import thebetweenlands.common.recipe.misc.RecipeLurkerSkinPouchUpgrades;
import thebetweenlands.common.recipe.misc.RecipesCircleGems;
import thebetweenlands.common.recipe.misc.RecipesCoating;
import thebetweenlands.common.recipe.misc.RecipesLifeCrystal;
import thebetweenlands.common.recipe.misc.RecipesPlantTonic;
import thebetweenlands.common.recipe.misc.ShapedRecipesBetweenlands;
import thebetweenlands.common.recipe.misc.ShapelessRecipesBetweenlands;
import thebetweenlands.common.recipe.purifier.PurifierRecipe;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.CustomRecipeRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityAnimator;
import thebetweenlands.util.RecipeHelper;

public class RecipeRegistry {
    private RecipeRegistry() {
    }

    public static void init() {
        RecipeRegistry.registerOreDictionary();
        RecipeRegistry.registerRecipes();
        RecipeRegistry.registerSmelting();
        RecipeRegistry.registerPurifierRecipes();
        RecipeRegistry.registerPestleAndMortarRecipes();
        RecipeRegistry.registerCompostRecipes();
        RecipeRegistry.registerDruidAltarRecipes();
        RecipeRegistry.registerAnimatorRecipes();
        CustomRecipeRegistry.loadCustomRecipes();
    }

    private static void registerOreDictionary() {
        OreDictionary.registerOre((String)"oreSulfur", (ItemStack)new ItemStack(BlockRegistry.SULFUR_ORE));
        OreDictionary.registerOre((String)"oreSyrmorite", (ItemStack)new ItemStack(BlockRegistry.SYRMORITE_ORE));
        OreDictionary.registerOre((String)"oreBone", (ItemStack)new ItemStack(BlockRegistry.SLIMY_BONE_ORE));
        OreDictionary.registerOre((String)"oreOctine", (ItemStack)new ItemStack(BlockRegistry.OCTINE_ORE));
        OreDictionary.registerOre((String)"oreValonite", (ItemStack)new ItemStack(BlockRegistry.VALONITE_ORE));
        OreDictionary.registerOre((String)"oreAquaMiddleGem", (ItemStack)new ItemStack(BlockRegistry.AQUA_MIDDLE_GEM_ORE));
        OreDictionary.registerOre((String)"oreGreenMiddleGem", (ItemStack)new ItemStack(BlockRegistry.GREEN_MIDDLE_GEM_ORE));
        OreDictionary.registerOre((String)"oreCrimsonMiddleGem", (ItemStack)new ItemStack(BlockRegistry.CRIMSON_MIDDLE_GEM_ORE));
        OreDictionary.registerOre((String)"oreLifeCrystal", (ItemStack)new ItemStack(BlockRegistry.LIFE_CRYSTAL_STALACTITE));
        OreDictionary.registerOre((String)"blockSulfur", (ItemStack)new ItemStack(BlockRegistry.SULFUR_BLOCK));
        OreDictionary.registerOre((String)"blockSyrmorite", (ItemStack)new ItemStack(BlockRegistry.SYRMORITE_BLOCK));
        OreDictionary.registerOre((String)"blockBone", (ItemStack)new ItemStack(BlockRegistry.SLIMY_BONE_BLOCK));
        OreDictionary.registerOre((String)"blockOctine", (ItemStack)new ItemStack(BlockRegistry.OCTINE_BLOCK));
        OreDictionary.registerOre((String)"blockValonite", (ItemStack)new ItemStack(BlockRegistry.VALONITE_BLOCK));
        OreDictionary.registerOre((String)"blockAquaMiddleGem", (ItemStack)new ItemStack(BlockRegistry.AQUA_MIDDLE_GEM_BLOCK));
        OreDictionary.registerOre((String)"blockGreenMiddleGem", (ItemStack)new ItemStack(BlockRegistry.GREEN_MIDDLE_GEM_BLOCK));
        OreDictionary.registerOre((String)"blockCrimsonMiddleGem", (ItemStack)new ItemStack(BlockRegistry.CRIMSON_MIDDLE_GEM_BLOCK));
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack(BlockRegistry.SILT_GLASS));
        OreDictionary.registerOre((String)"blockGlassColorless", (ItemStack)new ItemStack(BlockRegistry.SILT_GLASS));
        OreDictionary.registerOre((String)"paneGlass", (ItemStack)new ItemStack(BlockRegistry.SILT_GLASS_PANE));
        OreDictionary.registerOre((String)"paneGlassColorless", (ItemStack)new ItemStack(BlockRegistry.SILT_GLASS_PANE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(BlockRegistry.WEEDWOOD));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(BlockRegistry.LOG_WEEDWOOD));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(BlockRegistry.LOG_SAP));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(BlockRegistry.LOG_RUBBER));
        OreDictionary.registerOre((String)"dirt", (ItemStack)new ItemStack(BlockRegistry.SWAMP_DIRT));
        OreDictionary.registerOre((String)"dirt", (ItemStack)new ItemStack(BlockRegistry.COARSE_SWAMP_DIRT));
        OreDictionary.registerOre((String)"grass", (ItemStack)new ItemStack(BlockRegistry.SWAMP_GRASS));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack(BlockRegistry.LEAVES_WEEDWOOD_TREE));
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack(BlockRegistry.LEAVES_SAP_TREE));
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack(BlockRegistry.LEAVES_RUBBER_TREE));
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack(BlockRegistry.SAPLING_WEEDWOOD));
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack(BlockRegistry.SAPLING_SAP));
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack(BlockRegistry.SAPLING_RUBBER));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ItemRegistry.BULB_CAPPED_MUSHROOM_ITEM));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ItemRegistry.BLACK_HAT_MUSHROOM_ITEM));
        OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ItemRegistry.FLAT_HEAD_MUSHROOM_ITEM));
        OreDictionary.registerOre((String)"ingotSyrmorite", (ItemStack)ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        OreDictionary.registerOre((String)"ingotOctine", (ItemStack)new ItemStack(ItemRegistry.OCTINE_INGOT));
        OreDictionary.registerOre((String)"gemValonite", (ItemStack)ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        OreDictionary.registerOre((String)"gemAquaMiddleGem", (ItemStack)new ItemStack(ItemRegistry.AQUA_MIDDLE_GEM));
        OreDictionary.registerOre((String)"gemCrimsonMiddleGem", (ItemStack)new ItemStack(ItemRegistry.CRIMSON_MIDDLE_GEM));
        OreDictionary.registerOre((String)"gemGreenMiddleGem", (ItemStack)new ItemStack(ItemRegistry.GREEN_MIDDLE_GEM));
        OreDictionary.registerOre((String)"gemLifeCrystal", (ItemStack)new ItemStack(ItemRegistry.LIFE_CRYSTAL));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack(BlockRegistry.WEEDWOOD_PLANK_SLAB));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack(BlockRegistry.RUBBER_TREE_PLANK_SLAB));
        OreDictionary.registerOre((String)"torch", (ItemStack)new ItemStack(BlockRegistry.SULFUR_TORCH));
        OreDictionary.registerOre((String)"bone", (ItemStack)ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        OreDictionary.registerOre((String)"cobblestone", (ItemStack)new ItemStack(BlockRegistry.BETWEENSTONE));
        OreDictionary.registerOre((String)"stone", (ItemStack)new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE));
        OreDictionary.registerOre((String)"sand", (ItemStack)new ItemStack(BlockRegistry.SILT));
        OreDictionary.registerOre((String)"workbench", (ItemStack)new ItemStack(BlockRegistry.WEEDWOOD_WORKBENCH));
        OreDictionary.registerOre((String)"chest", (ItemStack)new ItemStack(BlockRegistry.WEEDWOOD_CHEST));
        OreDictionary.registerOre((String)"chestWood", (ItemStack)new ItemStack(BlockRegistry.WEEDWOOD_CHEST));
        OreDictionary.registerOre((String)"vine", (ItemStack)new ItemStack(BlockRegistry.POISON_IVY));
        OreDictionary.registerOre((String)"vine", (ItemStack)new ItemStack(BlockRegistry.THORNS));
        OreDictionary.registerOre((String)"sugarcane", (ItemStack)new ItemStack(ItemRegistry.SWAMP_REED_ITEM));
        OreDictionary.registerOre((String)"stickWood", (ItemStack)ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.ASTATOS));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.BETWEEN_YOU_AND_ME));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.CHRISTMAS_ON_THE_MARSH));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.THE_EXPLORER));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.HAG_DANCE));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.LONELY_FIRE));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.MYSTERIOUS_RECORD));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.ANCIENT));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.BENEATH_A_GREEN_SKY));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.DJ_WIGHTS_MIXTAPE));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.ONWARDS));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.STUCK_IN_THE_MUD));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.WANDERING_WISPS));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(ItemRegistry.WATERLOGGED));
    }

    private static void registerRecipes() {
        RecipeSorter.register((String)"thebetweenlands:shaped", ShapedRecipesBetweenlands.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:minecraft:shaped");
        RecipeSorter.register((String)"thebetweenlands:shapeless", ShapelessRecipesBetweenlands.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:thebetweenlands:shaped before:minecraft:shapeless");
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_PICKAXE, 1), "XXX", " # ", " # ", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_SHOVEL, 1), "X", "#", "#", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_AXE, 1), "XX", "X#", " #", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_SWORD, 1), "X", "X", "#", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.BONE_PICKAXE, 1), "XXX", " # ", " # ", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.BONE_SHOVEL, 1), "X", "#", "#", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.BONE_AXE, 1), "XX", "X#", " #", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.BONE_SWORD, 1), "X", "X", "#", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.OCTINE_PICKAXE, 1), "XXX", " # ", " # ", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), new ItemStack(ItemRegistry.OCTINE_INGOT));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.OCTINE_SHOVEL, 1), "X", "#", "#", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), new ItemStack(ItemRegistry.OCTINE_INGOT));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.OCTINE_AXE, 1), "XX", "X#", " #", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), new ItemStack(ItemRegistry.OCTINE_INGOT));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.OCTINE_SWORD, 1), "X", "X", "#", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), new ItemStack(ItemRegistry.OCTINE_INGOT));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.VALONITE_PICKAXE, 1), "XXX", " # ", " # ", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.VALONITE_SHOVEL, 1), "X", "#", "#", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.VALONITE_AXE, 1), "XX", "X#", " #", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.VALONITE_SWORD, 1), "X", "X", "#", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.OCTINE_SHIELD), "XXX", "XXX", " X ", Character.valueOf('X'), ItemRegistry.OCTINE_INGOT);
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.VALONITE_SHIELD), "XIX", "XXX", " X ", Character.valueOf('X'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1), Character.valueOf('I'), BlockRegistry.PITSTONE);
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_SHIELD), "XIX", "XXX", " X ", Character.valueOf('X'), new ItemStack(BlockRegistry.WEEDWOOD, 1, Short.MAX_VALUE), Character.valueOf('I'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_SHIELD), "XIX", "XXX", " X ", Character.valueOf('X'), new ItemStack(BlockRegistry.LOG_WEEDWOOD, 1, Short.MAX_VALUE), Character.valueOf('I'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.SYRMORITE_SHIELD), "XXX", "XXX", " X ", Character.valueOf('X'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.BONE_SHIELD), "XIX", "XXX", " X ", Character.valueOf('X'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1), Character.valueOf('I'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.DENTROTHYST_SHIELD_GREEN), "XIX", "XXX", " X ", Character.valueOf('X'), new ItemStack(BlockRegistry.DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.GREEN.getMeta()), Character.valueOf('I'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.DENTROTHYST_SHIELD_ORANGE), "XIX", "XXX", " X ", Character.valueOf('X'), new ItemStack(BlockRegistry.DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.ORANGE.getMeta()), Character.valueOf('I'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.DENTROTHYST_SHIELD_GREEN_POLISHED), "XIX", "XXX", " X ", Character.valueOf('X'), new ItemStack(BlockRegistry.POLISHED_DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.GREEN.getMeta()), Character.valueOf('I'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.DENTROTHYST_SHIELD_ORANGE_POLISHED), "XIX", "XXX", " X ", Character.valueOf('X'), new ItemStack(BlockRegistry.POLISHED_DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.ORANGE.getMeta()), Character.valueOf('I'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.LURKER_SKIN_SHIELD), "XIX", "XXX", " X ", Character.valueOf('X'), ItemMisc.EnumItemMisc.LURKER_SKIN.create(1), Character.valueOf('I'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_BOW, 1), " #X", "# X", " #X", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.ANGLER_TOOTH_ARROW, 4), "X", "#", "Y", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.ANGLER_TOOTH.create(1), Character.valueOf('Y'), ItemMisc.EnumItemMisc.DRAGONFLY_WING.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.OCTINE_ARROW, 4), "X", "#", "Y", Character.valueOf('#'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), new ItemStack(ItemRegistry.OCTINE_INGOT), Character.valueOf('Y'), ItemMisc.EnumItemMisc.DRAGONFLY_WING.create(1));
        RecipeHelper.addShapelessRecipe(new ItemStack(ItemRegistry.POISONED_ANGLER_TOOTH_ARROW, 1), ItemMisc.EnumItemMisc.POISON_GLAND.create(1), new ItemStack(ItemRegistry.ANGLER_TOOTH_ARROW));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.SYRMORITE_SHEARS, 1), " #", "# ", Character.valueOf('#'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.SICKLE, 1), " vv", "v s", "  r", Character.valueOf('v'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1), Character.valueOf('s'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('r'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.ROPE_ITEM, 1), "#", "#", "#", Character.valueOf('#'), new ItemStack(BlockRegistry.HANGER));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.ROPE_ITEM, 1), "#", "#", "#", Character.valueOf('#'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.NET, 1), "SRR", "SRR", "S  ", Character.valueOf('S'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('R'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.LURKER_SKIN_POUCH), "RRR", "L L", "LLL", Character.valueOf('L'), ItemMisc.EnumItemMisc.LURKER_SKIN.create(1), Character.valueOf('R'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        GameRegistry.addRecipe((IRecipe)new RecipeLurkerSkinPouchUpgrades());
        RecipeHelper.addShapelessRecipe(new ItemStack(ItemRegistry.SWAMP_TALISMAN, 1), ItemPlantDrop.EnumItemPlantDrop.MOSS_ITEM.create(1), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1), new ItemStack(ItemRegistry.LIFE_CRYSTAL, 1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.LURKER_SKIN_HELMET, 1), "###", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.LURKER_SKIN.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.LURKER_SKIN_CHESTPLATE, 1), "# #", "###", "###", Character.valueOf('#'), ItemMisc.EnumItemMisc.LURKER_SKIN.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.LURKER_SKIN_LEGGINGS, 1), "###", "# #", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.LURKER_SKIN.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.LURKER_SKIN_BOOTS, 1), "# #", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.LURKER_SKIN.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.BONE_HELMET, 1), "###", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.BONE_CHESTPLATE, 1), "# #", "###", "###", Character.valueOf('#'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.BONE_LEGGINGS, 1), "###", "# #", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.BONE_BOOTS, 1), "# #", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.SYRMORITE_HELMET, 1), "###", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.SYRMORITE_CHESTPLATE, 1), "# #", "###", "###", Character.valueOf('#'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.SYRMORITE_LEGGINGS, 1), "###", "# #", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.SYRMORITE_BOOTS, 1), "# #", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.VALONITE_HELMET, 1), "###", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.VALONITE_CHESTPLATE, 1), "# #", "###", "###", Character.valueOf('#'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.VALONITE_LEGGINGS, 1), "###", "# #", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.VALONITE_BOOTS, 1), "# #", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.RUBBER_BOOTS, 1), "# #", "# #", Character.valueOf('#'), ItemMisc.EnumItemMisc.RUBBER_BALL.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SULFUR_TORCH, 4), "#", "I", Character.valueOf('I'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('#'), ItemMisc.EnumItemMisc.SULFUR.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_PLANKS, 4), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.LOG_WEEDWOOD, 1, Short.MAX_VALUE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_PLANKS, 4), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.WEEDWOOD, 1, Short.MAX_VALUE));
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(4), "p", "p", Character.valueOf('p'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_WORKBENCH), "xx", "xx", Character.valueOf('x'), BlockRegistry.WEEDWOOD_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_CHEST), "xxx", "x x", "xxx", Character.valueOf('x'), BlockRegistry.WEEDWOOD_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SULFUR_FURNACE), "xxx", "x x", "xxx", Character.valueOf('x'), BlockRegistry.BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SULFUR_FURNACE_DUAL), "xxx", "xfx", "xxx", Character.valueOf('x'), BlockRegistry.BETWEENSTONE, Character.valueOf('f'), BlockRegistry.SULFUR_FURNACE);
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(4), "p", "p", "p", Character.valueOf('p'), new ItemStack(ItemRegistry.SWAMP_REED_ITEM));
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.WEEDWOOD_BOWL.create(4), "x x", " x ", Character.valueOf('x'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_BUCKET), " X ", "x x", " x ", Character.valueOf('x'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS), Character.valueOf('X'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.SYRMORITE_BUCKET), " X ", "x x", " x ", Character.valueOf('x'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_LADDER, 3), "X X", "xxx", "X X", Character.valueOf('x'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_PLANK_BUTTON), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_BUTTON), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_PLANK_PRESSURE_PLATE), "xx", Character.valueOf('x'), BlockRegistry.WEEDWOOD_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_PRESSURE_PLATE), "xx", Character.valueOf('x'), BlockRegistry.SMOOTH_BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SYRMORITE_PRESSURE_PLATE), "xx", Character.valueOf('x'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MUD_FLOWER_POT), "x x", " x ", Character.valueOf('x'), ItemMisc.EnumItemMisc.MUD_BRICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_LEVER), "X", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.LOG_WEEDWOOD), Character.valueOf('X'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.PESTLE), "X", "x", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.CRAGROCK), Character.valueOf('X'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.ITEM_SHELF), "xxx", "   ", "xxx", Character.valueOf('x'), BlockRegistry.WEEDWOOD_PLANK_SLAB);
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_ROWBOAT), "x x", "xxx", Character.valueOf('x'), BlockRegistry.WEEDWOOD_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.CAVING_ROPE, 8), "rrr", "ror", "rrr", Character.valueOf('r'), new ItemStack(ItemRegistry.ROPE_ITEM), Character.valueOf('o'), new ItemStack(ItemRegistry.OCTINE_INGOT));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SYRMORITE_HOPPER), "s s", "scs", " s ", Character.valueOf('s'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1), Character.valueOf('c'), new ItemStack(BlockRegistry.WEEDWOOD_CHEST));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_SIGN_ITEM, 3), "SSS", "SSS", " x ", Character.valueOf('x'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('S'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.MOSS_BED_ITEM), "xxx", "PPP", Character.valueOf('x'), ItemPlantDrop.EnumItemPlantDrop.MOSS_ITEM.create(1), Character.valueOf('P'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.MOSS_BED_ITEM), "xxx", "PPP", Character.valueOf('x'), ItemPlantDrop.EnumItemPlantDrop.CAVE_MOSS_ITEM.create(1), Character.valueOf('P'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.MOSS_BED_ITEM), "xxx", "PPP", Character.valueOf('x'), new ItemStack(BlockRegistry.MOSS), Character.valueOf('P'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.MOSS_BED_ITEM), "xxx", "PPP", Character.valueOf('x'), new ItemStack(BlockRegistry.CAVE_MOSS), Character.valueOf('P'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.PARCHMENT.create(3), "###", Character.valueOf('#'), ItemMisc.EnumItemMisc.DRY_BARK.create(1));
        RecipeHelper.addRecipe(ItemAmulet.createStack(CircleGemType.NONE), "XXX", "X X", " # ", Character.valueOf('#'), ItemMisc.EnumItemMisc.AMULET_SOCKET.create(1), Character.valueOf('X'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PURIFIER), "x x", "xxx", "ooo", Character.valueOf('x'), BlockRegistry.WEEDWOOD_PLANKS, Character.valueOf('o'), new ItemStack(ItemRegistry.OCTINE_INGOT));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.COMPOST_BIN), "bxb", "x x", "x x", Character.valueOf('x'), BlockRegistry.WEEDWOOD_PLANKS, Character.valueOf('b'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.ANIMATOR), "xxx", "shs", "bbb", Character.valueOf('x'), BlockRegistry.WEEDWOOD_PLANKS, Character.valueOf('s'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('h'), new ItemStack(ItemRegistry.WIGHT_HEART), Character.valueOf('b'), new ItemStack(BlockRegistry.BETWEENSTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MORTAR), "x x", "xxx", "s s", Character.valueOf('x'), BlockRegistry.CRAGROCK, Character.valueOf('s'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.INFUSER), "o o", "opo", "sos", Character.valueOf('o'), new ItemStack(ItemRegistry.OCTINE_INGOT), Character.valueOf('d'), new ItemStack(Item.func_150898_a((Block)BlockRegistry.DENTROTHYST)), Character.valueOf('p'), new ItemStack(ItemRegistry.PESTLE), Character.valueOf('s'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.GECKO_CAGE), "sps", "rrr", "sps", Character.valueOf('s'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1), Character.valueOf('p'), new ItemStack(Item.func_150898_a((Block)BlockRegistry.WEEDWOOD_PLANK_SLAB)), Character.valueOf('r'), ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_JUKEBOX), "xxx", "xVx", "xxx", Character.valueOf('x'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS), Character.valueOf('V'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MUD_BRICKS, 4), "xx", "xx", Character.valueOf('x'), ItemMisc.EnumItemMisc.MUD_BRICK.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_TILES, 4), "xx", "xx", Character.valueOf('x'), new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_TILES, 4), "xx", "xx", Character.valueOf('x'), new ItemStack(BlockRegistry.SMOOTH_PITSTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_BRICKS, 4), "xx", "xx", Character.valueOf('x'), new ItemStack(BlockRegistry.BETWEENSTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_BRICKS, 4), "xx", "xx", Character.valueOf('x'), new ItemStack(BlockRegistry.PITSTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_CHISELED, 4), "x", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.BETWEENSTONE_BRICK_SLAB));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_CHISELED, 4), "x", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.PITSTONE_BRICK_SLAB));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_TILES, 4), "xx", "xx", Character.valueOf('x'), new ItemStack(BlockRegistry.SMOOTH_CRAGROCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_BRICKS, 4), "xx", "xx", Character.valueOf('x'), new ItemStack(BlockRegistry.CRAGROCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_CHISELED, 4), "x", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.CRAGROCK_BRICK_SLAB));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_TILES, 4), "xx", "xx", Character.valueOf('x'), new ItemStack(BlockRegistry.POLISHED_LIMESTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_BRICKS, 4), "xx", "xx", Character.valueOf('x'), new ItemStack(BlockRegistry.LIMESTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_CHISELED, 4), "x", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.LIMESTONE_BRICK_SLAB));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SULFUR_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), ItemMisc.EnumItemMisc.SULFUR.create(1));
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.SULFUR.create(9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.SULFUR_BLOCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.OCTINE_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(ItemRegistry.OCTINE_INGOT));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SYRMORITE_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.SYRMORITE_BLOCK));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.OCTINE_INGOT, 9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.OCTINE_BLOCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.VALONITE_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), ItemMisc.EnumItemMisc.VALONITE_SHARD.create(1));
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.VALONITE_SHARD.create(9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.VALONITE_BLOCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.THATCH, 4), "xx", "xx", Character.valueOf('x'), ItemMisc.EnumItemMisc.DRIED_SWAMP_REED.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.RUBBER_TREE_PLANKS, 4), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.LOG_RUBBER, 1, Short.MAX_VALUE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MIRE_CORAL_BLOCK, 4), "xx", "xx", Character.valueOf('x'), ItemPlantDrop.EnumItemPlantDrop.MIRE_CORAL_ITEM.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.DEEP_WATER_CORAL_BLOCK, 4), "xx", "xx", Character.valueOf('x'), ItemPlantDrop.EnumItemPlantDrop.DEEP_WATER_CORAL_ITEM.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BULB_CAPPED_MUSHROOM_CAP, 4), "xx", "xx", Character.valueOf('x'), ItemRegistry.BULB_CAPPED_MUSHROOM_ITEM);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SLIMY_BONE_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), ItemMisc.EnumItemMisc.SLIMY_BONE.create(1));
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.SLIMY_BONE.create(9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.SLIMY_BONE_BLOCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.AQUA_MIDDLE_GEM_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(ItemRegistry.AQUA_MIDDLE_GEM));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.AQUA_MIDDLE_GEM, 9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.AQUA_MIDDLE_GEM_BLOCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRIMSON_MIDDLE_GEM_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(ItemRegistry.CRIMSON_MIDDLE_GEM));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.CRIMSON_MIDDLE_GEM, 9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.CRIMSON_MIDDLE_GEM_BLOCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.GREEN_MIDDLE_GEM_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(ItemRegistry.GREEN_MIDDLE_GEM));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.GREEN_MIDDLE_GEM, 9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.GREEN_MIDDLE_GEM_BLOCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.COMPOST_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), ItemMisc.EnumItemMisc.COMPOST.create(1));
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.COMPOST.create(9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.COMPOST_BLOCK));
        RecipeHelper.addShapelessRecipe(new ItemStack(BlockRegistry.MOSSY_BETWEENSTONE_BRICKS, 1), ItemPlantDrop.EnumItemPlantDrop.MOSS_ITEM.create(1), new ItemStack(BlockRegistry.BETWEENSTONE_BRICKS));
        RecipeHelper.addShapelessRecipe(new ItemStack(BlockRegistry.MOSSY_BETWEENSTONE_BRICKS, 1), ItemPlantDrop.EnumItemPlantDrop.CAVE_MOSS_ITEM.create(1), new ItemStack(BlockRegistry.BETWEENSTONE_BRICKS));
        RecipeHelper.addShapelessRecipe(new ItemStack(BlockRegistry.MOSSY_BETWEENSTONE_TILES, 1), ItemPlantDrop.EnumItemPlantDrop.MOSS_ITEM.create(1), new ItemStack(BlockRegistry.BETWEENSTONE_TILES));
        RecipeHelper.addShapelessRecipe(new ItemStack(BlockRegistry.MOSSY_BETWEENSTONE_TILES, 1), ItemPlantDrop.EnumItemPlantDrop.CAVE_MOSS_ITEM.create(1), new ItemStack(BlockRegistry.BETWEENSTONE_TILES));
        RecipeHelper.addShapelessRecipe(new ItemStack(BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE, 1), ItemPlantDrop.EnumItemPlantDrop.MOSS_ITEM.create(1), new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE));
        RecipeHelper.addShapelessRecipe(new ItemStack(BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE, 1), ItemPlantDrop.EnumItemPlantDrop.CAVE_MOSS_ITEM.create(1), new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.RUBBER_BLOCK), "xxx", "xxx", "xxx", Character.valueOf('x'), ItemMisc.EnumItemMisc.RUBBER_BALL.create(1));
        RecipeHelper.addRecipe(ItemMisc.EnumItemMisc.RUBBER_BALL.create(9), "#", Character.valueOf('#'), new ItemStack(BlockRegistry.RUBBER_BLOCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WOOD_CHIP_PATH, 4), "###", Character.valueOf('#'), ItemCrushed.EnumItemCrushed.GROUND_WEEDWOOD_BARK.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WALKWAY, 2), "SSS", "x x", Character.valueOf('x'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('S'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.WEEDWOOD_DOOR_ITEM, 3), "##", "##", "##", Character.valueOf('#'), BlockRegistry.WEEDWOOD_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.RUBBER_TREE_PLANK_DOOR_ITEM, 3), "##", "##", "##", Character.valueOf('#'), BlockRegistry.RUBBER_TREE_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.SYRMORITE_DOOR_ITEM, 3), "##", "##", "##", Character.valueOf('#'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_TRAPDOOR, 2), "###", "###", Character.valueOf('#'), BlockRegistry.WEEDWOOD_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.RUBBER_TREE_PLANK_TRAPDOOR, 2), "###", "###", Character.valueOf('#'), BlockRegistry.RUBBER_TREE_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SYRMORITE_TRAPDOOR, 2), "###", "###", Character.valueOf('#'), ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.CRAGROCK);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.PITSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_BRICK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.BETWEENSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_BRICK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.PITSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MUD_BRICK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.MUD_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_BRICK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.CRAGROCK_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_BRICK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.LIMESTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.LIMESTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.SMOOTH_BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_CRAGROCK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.SMOOTH_CRAGROCK);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_PITSTONE_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.SMOOTH_PITSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.TAR_SOLID_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.TAR_SOLID);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.TEMPLE_BRICK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.TEMPLE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_PLANK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.WEEDWOOD_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.RUBBER_TREE_PLANK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.RUBBER_TREE_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MOSSY_BETWEENSTONE_BRICK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.MOSSY_BETWEENSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRACKED_BETWEENSTONE_BRICK_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.CRACKED_BETWEENSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.POLISHED_LIMESTONE_STAIRS, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.POLISHED_LIMESTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.PITSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_BRICK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.BETWEENSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_BRICK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.PITSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MUD_BRICK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.MUD_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.CRAGROCK);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_BRICK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.CRAGROCK_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_BRICK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.LIMESTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.LIMESTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.POLISHED_LIMESTONE_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.POLISHED_LIMESTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.SMOOTH_BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.TAR_SOLID_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.TAR_SOLID);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.TEMPLE_BRICK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.TEMPLE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_PITSTONE_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.SMOOTH_PITSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_CRAGROCK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.SMOOTH_CRAGROCK);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MOSSY_BETWEENSTONE_BRICK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.MOSSY_BETWEENSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRACKED_BETWEENSTONE_BRICK_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.CRACKED_BETWEENSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE_WALL, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_LOG_FENCE, 3), "SxS", "SxS", Character.valueOf('x'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('S'), new ItemStack(BlockRegistry.LOG_WEEDWOOD));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_PLANK_FENCE, 3), "SxS", "SxS", Character.valueOf('x'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('S'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.RUBBER_TREE_PLANK_FENCE, 3), "SxS", "SxS", Character.valueOf('x'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('S'), new ItemStack(BlockRegistry.RUBBER_TREE_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_LOG_FENCE_GATE, 1), "xSx", "xSx", Character.valueOf('x'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('S'), new ItemStack(BlockRegistry.LOG_WEEDWOOD));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_PLANK_FENCE_GATE, 1), "xSx", "xSx", Character.valueOf('x'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('S'), new ItemStack(BlockRegistry.WEEDWOOD_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.RUBBER_TREE_PLANK_FENCE_GATE, 1), "xSx", "xSx", Character.valueOf('x'), ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1), Character.valueOf('S'), new ItemStack(BlockRegistry.RUBBER_TREE_PLANKS));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.CRAGROCK);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.PITSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_BRICK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.BETWEENSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MUD_BRICK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.MUD_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_BRICK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.CRAGROCK_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_BRICK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.LIMESTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.POLISHED_LIMESTONE_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.POLISHED_LIMESTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.LIMESTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.SMOOTH_BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_CRAGROCK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.SMOOTH_CRAGROCK);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SMOOTH_PITSTONE_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.SMOOTH_PITSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_BRICK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.PITSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.TAR_SOLID_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.TAR_SOLID);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.TEMPLE_BRICK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.TEMPLE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.WEEDWOOD_PLANK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.WEEDWOOD_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.RUBBER_TREE_PLANK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.RUBBER_TREE_PLANKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.THATCH_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.THATCH);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.MOSSY_BETWEENSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRACKED_BETWEENSTONE_BRICK_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.CRACKED_BETWEENSTONE_BRICKS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE_SLAB, 6), "###", Character.valueOf('#'), BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.BETWEENSTONE_PILLAR, 2), "x", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.PITSTONE_PILLAR, 2), "x", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.SMOOTH_PITSTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.LIMESTONE_PILLAR, 2), "x", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.POLISHED_LIMESTONE));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.CRAGROCK_PILLAR, 2), "x", "x", Character.valueOf('x'), new ItemStack(BlockRegistry.SMOOTH_CRAGROCK));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.THATCH_ROOF, 4), "x  ", "xx ", "xxx", Character.valueOf('x'), BlockRegistry.THATCH);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.SILT_GLASS_PANE, 6), "xxx", "xxx", Character.valueOf('x'), BlockRegistry.SILT_GLASS);
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.POLISHED_DENTROTHYST_PANE, 6, BlockDentrothyst.EnumDentrothyst.GREEN.getMeta()), "xxx", "xxx", Character.valueOf('x'), new ItemStack(BlockRegistry.POLISHED_DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.GREEN.getMeta()));
        RecipeHelper.addRecipe(new ItemStack(BlockRegistry.POLISHED_DENTROTHYST_PANE, 6, BlockDentrothyst.EnumDentrothyst.ORANGE.getMeta()), "xxx", "xxx", Character.valueOf('x'), new ItemStack(BlockRegistry.POLISHED_DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.ORANGE.getMeta()));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.REED_DONUT, 1), " # ", "# #", " # ", Character.valueOf('#'), ItemMisc.EnumItemMisc.DRIED_SWAMP_REED.create(1));
        RecipeHelper.addShapelessRecipe(new ItemStack(ItemRegistry.JAM_DONUT, 1), new ItemStack(ItemRegistry.REED_DONUT), new ItemStack(ItemRegistry.MIDDLE_FRUIT));
        RecipeHelper.addShapelessRecipe(new ItemStack(ItemRegistry.GERTS_DONUT, 1), new ItemStack(ItemRegistry.REED_DONUT), new ItemStack(ItemRegistry.WIGHT_HEART), new ItemStack(Items.field_151123_aH));
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.CRAB_STICK, 3), "  #", " # ", "#  ", Character.valueOf('#'), new ItemStack(ItemRegistry.SILT_CRAB_CLAW));
        RecipeHelper.addShapelessRecipe(new ItemStack(ItemRegistry.SAP_JELLO, 1), new ItemStack(ItemRegistry.SLUDGE_JELLO), new ItemStack(ItemRegistry.SAP_BALL));
        RecipeHelper.addShapelessRecipe(new ItemStack(ItemRegistry.MIDDLE_FRUIT_JELLO, 1), new ItemStack(ItemRegistry.SLUDGE_JELLO), new ItemStack(ItemRegistry.MIDDLE_FRUIT));
        RecipeHelper.addShapelessRecipe(new ItemStack(ItemRegistry.NETTLE_SOUP, 1), ItemMisc.EnumItemMisc.WEEDWOOD_BOWL.create(1), ItemRegistry.BLACK_HAT_MUSHROOM_ITEM, ItemRegistry.FLAT_HEAD_MUSHROOM_ITEM, BlockRegistry.NETTLE);
        RecipeHelper.addShapelessRecipe(new ItemStack(ItemRegistry.NETTLE_SOUP, 1), ItemMisc.EnumItemMisc.WEEDWOOD_BOWL.create(1), ItemRegistry.BLACK_HAT_MUSHROOM_ITEM, ItemRegistry.FLAT_HEAD_MUSHROOM_ITEM, BlockRegistry.NETTLE_FLOWERED);
        RecipeHelper.addRecipe(new ItemStack(ItemRegistry.TARMINION, 1), "ttt", "tht", "ttt", Character.valueOf('t'), ItemMisc.EnumItemMisc.TAR_DRIP.create(1), Character.valueOf('h'), ItemMisc.EnumItemMisc.TAR_BEAST_HEART_ANIMATED.create(1));
        RecipeSorter.register((String)"thebetweenlands:recipesCircleGems", RecipesCircleGems.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new RecipesCircleGems());
        RecipeSorter.register((String)"thebetweenlands:recipesCoating", RecipesCoating.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new RecipesCoating());
        RecipeSorter.register((String)"thebetweenlands:recipesLifeCrystal", RecipesLifeCrystal.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new RecipesLifeCrystal());
        RecipeSorter.register((String)"thebetweenlands:recipesPlantTonic", RecipesPlantTonic.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new RecipesPlantTonic());
    }

    private static void registerSmelting() {
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.SYRMORITE_ORE), (ItemStack)ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1), (float)0.7f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.OCTINE_ORE), (ItemStack)new ItemStack(ItemRegistry.OCTINE_INGOT), (float)0.7f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.DAMP_TORCH), (ItemStack)new ItemStack(Blocks.field_150478_aa), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.SWAMP_REED_ITEM), (ItemStack)ItemMisc.EnumItemMisc.DRIED_SWAMP_REED.create(1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.MUD), (ItemStack)ItemMisc.EnumItemMisc.MUD_BRICK.create(1), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.KRAKEN_TENTACLE), (ItemStack)new ItemStack(ItemRegistry.KRAKEN_CALAMARI, 5), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.SWAMP_KELP_ITEM), (ItemStack)new ItemStack(ItemRegistry.FRIED_SWAMP_KELP), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.ANGLER_MEAT_RAW), (ItemStack)new ItemStack(ItemRegistry.ANGLER_MEAT_COOKED), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.FROG_LEGS_RAW), (ItemStack)new ItemStack(ItemRegistry.FROG_LEGS_COOKED), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.SNAIL_FLESH_RAW), (ItemStack)new ItemStack(ItemRegistry.SNAIL_FLESH_COOKED), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.BETWEENSTONE), (ItemStack)new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.PITSTONE), (ItemStack)new ItemStack(BlockRegistry.SMOOTH_PITSTONE), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.CRAGROCK), (ItemStack)new ItemStack(BlockRegistry.SMOOTH_CRAGROCK), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.LIMESTONE), (ItemStack)new ItemStack(BlockRegistry.POLISHED_LIMESTONE), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.GREEN.getMeta()), (ItemStack)new ItemStack(BlockRegistry.POLISHED_DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.GREEN.getMeta()), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.ORANGE.getMeta()), (ItemStack)new ItemStack(BlockRegistry.POLISHED_DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.ORANGE.getMeta()), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.SLUDGE_BALL), (ItemStack)new ItemStack(ItemRegistry.SLUDGE_JELLO), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.SILT), (ItemStack)new ItemStack(BlockRegistry.SILT_GLASS), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.BETWEENSTONE_TILES), (ItemStack)new ItemStack(BlockRegistry.CRACKED_BETWEENSTONE_TILES), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.BETWEENSTONE_BRICKS), (ItemStack)new ItemStack(BlockRegistry.CRACKED_BETWEENSTONE_BRICKS), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.WEEDWOOD_BUCKET_RUBBER), (ItemStack)ItemMisc.EnumItemMisc.RUBBER_BALL.create(1), (float)0.5f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.SYRMORITE_BUCKET_RUBBER), (ItemStack)new ItemStack(ItemRegistry.SYRMORITE_BUCKET_SOLID_RUBBER), (float)0.5f);
    }

    private static void registerDruidAltarRecipes() {
        DruidAltarRecipe.addRecipe(ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_1.create(1), ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_2.create(1), ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_3.create(1), ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_4.create(1), ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_0.create(1));
    }

    private static void registerCompostRecipes() {
        CompostRecipe.addRecipe(30, 12000, ItemMisc.EnumItemMisc.DRY_BARK.create(1));
        CompostRecipe.addRecipe(25, 12000, Item.func_150898_a((Block)BlockRegistry.HOLLOW_LOG));
        CompostRecipe.addRecipe(25, 12000, Item.func_150898_a((Block)BlockRegistry.LOG_ROTTEN_BARK));
        CompostRecipe.addRecipe(10, 8000, Item.func_150898_a((Block)BlockRegistry.SUNDEW));
        CompostRecipe.addRecipe(6, 10000, Item.func_150898_a((Block)BlockRegistry.SWAMP_DOUBLE_TALLGRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.PHRAGMITES));
        CompostRecipe.addRecipe(6, 10000, Item.func_150898_a((Block)BlockRegistry.TALL_CATTAIL));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.CARDINAL_FLOWER));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BROOMSEDGE));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.WEEPING_BLUE));
        CompostRecipe.addRecipe(12, 11000, Item.func_150898_a((Block)BlockRegistry.PITCHER_PLANT));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.BOG_BEAN_FLOWER));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.BOG_BEAN_STALK));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.GOLDEN_CLUB_FLOWER));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.GOLDEN_CLUB_STALK));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.MARSH_MARIGOLD_FLOWER));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.MARSH_MARIGOLD_STALK));
        CompostRecipe.addRecipe(3, 5000, Item.func_150898_a((Block)BlockRegistry.SWAMP_KELP));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.WATER_WEEDS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLADDERWORT_FLOWER));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLADDERWORT_STALK));
        CompostRecipe.addRecipe(20, 12000, Item.func_150898_a((Block)BlockRegistry.ROOT));
        CompostRecipe.addRecipe(20, 12000, Item.func_150898_a((Block)BlockRegistry.ROOT_UNDERWATER));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLACK_HAT_MUSHROOM));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.FLAT_HEAD_MUSHROOM));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BULB_CAPPED_MUSHROOM));
        CompostRecipe.addRecipe(4, 6000, Item.func_150898_a((Block)BlockRegistry.SWAMP_PLANT));
        CompostRecipe.addRecipe(12, 10000, Item.func_150898_a((Block)BlockRegistry.VENUS_FLY_TRAP));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.VOLARPAD));
        CompostRecipe.addRecipe(20, 12000, Item.func_150898_a((Block)BlockRegistry.WEEDWOOD_BUSH));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.THORNS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.POISON_IVY));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.MOSS));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.LICHEN));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.CAVE_MOSS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.CAVE_GRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.CATTAIL));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.SWAMP_TALLGRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.SHOOTS));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.NETTLE_FLOWERED));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.NETTLE));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.ARROW_ARUM));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BUTTON_BUSH));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.MARSH_HIBISCUS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.PICKEREL_WEED));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.SOFT_RUSH));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.MARSH_MALLOW));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLUE_IRIS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.COPPER_IRIS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLUE_EYED_GRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.MILKWEED));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BONESET));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BOTTLE_BRUSH_GRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.SLUDGECREEP));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.DEAD_WEEDWOOD_BUSH));
        CompostRecipe.addRecipe(3, 5000, Item.func_150898_a((Block)BlockRegistry.HANGER));
        CompostRecipe.addRecipe(3, 5000, Item.func_150898_a((Block)BlockRegistry.ALGAE));
        CompostRecipe.addRecipe(3, 5000, ItemRegistry.ROPE_ITEM);
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.MIRE_CORAL));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.DEEP_WATER_CORAL));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.SAPLING_RUBBER));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.SAPLING_SAP));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.SAPLING_WEEDWOOD));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_RUBBER_TREE));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_SAP_TREE));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_WEEDWOOD_TREE));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.FALLEN_LEAVES));
        CompostRecipe.addRecipe(3, 5000, ItemRegistry.SWAMP_REED_ITEM);
        CompostRecipe.addRecipe(3, 5000, ItemMisc.EnumItemMisc.DRIED_SWAMP_REED.create(1));
        CompostRecipe.addRecipe(5, 8000, ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        CompostRecipe.addRecipe(5, 8000, ItemRegistry.TANGLED_ROOT);
        CompostRecipe.addRecipe(3, 5000, ItemRegistry.SWAMP_KELP_ITEM);
        CompostRecipe.addRecipe(5, 8000, ItemRegistry.FLAT_HEAD_MUSHROOM_ITEM);
        CompostRecipe.addRecipe(5, 8000, ItemRegistry.BLACK_HAT_MUSHROOM_ITEM);
        CompostRecipe.addRecipe(5, 8000, ItemRegistry.BULB_CAPPED_MUSHROOM_ITEM);
        CompostRecipe.addRecipe(12, 10000, ItemRegistry.YELLOW_DOTTED_FUNGUS);
        for (ItemCrushed.EnumItemCrushed enumItemCrushed : ItemCrushed.EnumItemCrushed.values()) {
            CompostRecipe.addRecipe(3, 4000, new ItemStack(ItemRegistry.ITEMS_CRUSHED, 1, enumItemCrushed.getID()));
        }
        for (Enum enum_ : ItemPlantDrop.EnumItemPlantDrop.values()) {
            CompostRecipe.addRecipe(3, 4000, new ItemStack(ItemRegistry.ITEMS_PLANT_DROP, 1, ((ItemPlantDrop.EnumItemPlantDrop)enum_).getID()));
        }
    }

    private static void registerPestleAndMortarRecipes() {
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LIMESTONE_FLUX.create(1), new ItemStack(BlockRegistry.LIMESTONE));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LIMESTONE_FLUX.create(1), new ItemStack(BlockRegistry.POLISHED_LIMESTONE));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_ALGAE.create(1), ItemPlantDrop.EnumItemPlantDrop.ALGAE_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_ANGLER_TOOTH.create(1), ItemMisc.EnumItemMisc.ANGLER_TOOTH.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_AQUA_MIDDLE_GEM.create(1), new ItemStack(ItemRegistry.AQUA_MIDDLE_GEM, 1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_ARROW_ARUM.create(1), ItemPlantDrop.EnumItemPlantDrop.ARROW_ARUM_LEAF.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLACKHAT_MUSHROOM.create(1), new ItemStack(ItemRegistry.BLACK_HAT_MUSHROOM_ITEM));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLOOD_SNAIL_SHELL.create(1), ItemMisc.EnumItemMisc.BLOOD_SNAIL_SHELL.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLUE_EYED_GRASS.create(1), ItemPlantDrop.EnumItemPlantDrop.BLUE_EYED_GRASS_FLOWERS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLUE_IRIS.create(1), ItemPlantDrop.EnumItemPlantDrop.BLUE_IRIS_PETAL.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BOG_BEAN.create(1), ItemPlantDrop.EnumItemPlantDrop.BOG_BEAN_FLOWER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BONESET.create(1), ItemPlantDrop.EnumItemPlantDrop.BONESET_FLOWERS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BOTTLE_BRUSH_GRASS.create(1), ItemPlantDrop.EnumItemPlantDrop.BOTTLE_BRUSH_GRASS_BLADES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BROOM_SEDGE.create(1), ItemPlantDrop.EnumItemPlantDrop.BROOM_SEDGE_LEAVES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BULB_CAPPED_MUSHROOM.create(1), new ItemStack(ItemRegistry.BULB_CAPPED_MUSHROOM_ITEM));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BUTTON_BUSH.create(1), ItemPlantDrop.EnumItemPlantDrop.BUTTON_BUSH_FLOWERS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CARDINAL_FLOWER.create(1), ItemPlantDrop.EnumItemPlantDrop.CARDINAL_FLOWER_PETALS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CATTAIL.create(1), ItemPlantDrop.EnumItemPlantDrop.CATTAIL_HEAD.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CAVE_GRASS.create(1), ItemPlantDrop.EnumItemPlantDrop.CAVE_GRASS_BLADES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CAVE_MOSS.create(1), ItemPlantDrop.EnumItemPlantDrop.CAVE_MOSS_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_COPPER_IRIS.create(1), ItemPlantDrop.EnumItemPlantDrop.COPPER_IRIS_PETALS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CRIMSON_MIDDLE_GEM.create(1), new ItemStack(ItemRegistry.CRIMSON_MIDDLE_GEM, 1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_DEEP_WATER_CORAL.create(1), ItemPlantDrop.EnumItemPlantDrop.DEEP_WATER_CORAL_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_DRIED_SWAMP_REED.create(1), ItemMisc.EnumItemMisc.DRIED_SWAMP_REED.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_FLATHEAD_MUSHROOM.create(1), new ItemStack(ItemRegistry.FLAT_HEAD_MUSHROOM_ITEM));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_GOLDEN_CLUB.create(1), ItemPlantDrop.EnumItemPlantDrop.GOLDEN_CLUB_FLOWER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_GREEN_MIDDLE_GEM.create(1), new ItemStack(ItemRegistry.GREEN_MIDDLE_GEM, 1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_LICHEN.create(1), ItemPlantDrop.EnumItemPlantDrop.LICHEN_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MARSH_HIBISCUS.create(1), ItemPlantDrop.EnumItemPlantDrop.MARSH_HIBISCUS_FLOWER.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MARSH_MALLOW.create(1), ItemPlantDrop.EnumItemPlantDrop.MARSH_MALLOW_FLOWER.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MARSH_MARIGOLD.create(1), ItemPlantDrop.EnumItemPlantDrop.MARSH_MARIGOLD_FLOWER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MILKWEED.create(1), ItemPlantDrop.EnumItemPlantDrop.MILKWEED_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MIRE_CORAL.create(1), ItemPlantDrop.EnumItemPlantDrop.MIRE_CORAL_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MIRE_SNAIL_SHELL.create(1), ItemMisc.EnumItemMisc.MIRE_SNAIL_SHELL.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MOSS.create(1), ItemPlantDrop.EnumItemPlantDrop.MOSS_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_NETTLE.create(1), ItemPlantDrop.EnumItemPlantDrop.NETTLE_LEAF.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_PHRAGMITES.create(1), ItemPlantDrop.EnumItemPlantDrop.PHRAGMITE_STEMS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_PICKEREL_WEED.create(1), ItemPlantDrop.EnumItemPlantDrop.PICKEREL_WEED_FLOWER.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SHOOTS.create(1), ItemPlantDrop.EnumItemPlantDrop.SHOOT_LEAVES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SLUDGECREEP.create(1), ItemPlantDrop.EnumItemPlantDrop.SLUDGECREEP_LEAVES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SOFT_RUSH.create(1), ItemPlantDrop.EnumItemPlantDrop.SOFT_RUSH_LEAVES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SUNDEW.create(1), ItemPlantDrop.EnumItemPlantDrop.SUNDEW_HEAD.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SWAMP_KELP.create(1), new ItemStack(ItemRegistry.SWAMP_KELP_ITEM));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SWAMP_GRASS_TALL.create(1), ItemPlantDrop.EnumItemPlantDrop.SWAMP_TALL_GRASS_BLADES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_TANGLED_ROOTS.create(1), new ItemStack(ItemRegistry.TANGLED_ROOT));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_WEEDWOOD_BARK.create(1), new ItemStack(BlockRegistry.LOG_WEEDWOOD));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_WEEDWOOD_BARK.create(1), ItemMisc.EnumItemMisc.DRY_BARK.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_HANGER.create(1), ItemPlantDrop.EnumItemPlantDrop.HANGER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_WATER_WEEDS.create(1), ItemPlantDrop.EnumItemPlantDrop.WATER_WEEDS_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_VENUS_FLY_TRAP.create(1), ItemPlantDrop.EnumItemPlantDrop.VENUS_FLY_TRAP_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_VOLARPAD.create(1), ItemPlantDrop.EnumItemPlantDrop.VOLARPAD_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_THORNS.create(1), ItemPlantDrop.EnumItemPlantDrop.THORNS_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_POISON_IVY.create(1), ItemPlantDrop.EnumItemPlantDrop.POISON_IVY_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_PITCHER_PLANT.create(1), ItemPlantDrop.EnumItemPlantDrop.PITCHER_PLANT_TRAP.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_GENERIC_LEAF.create(1), ItemPlantDrop.EnumItemPlantDrop.GENERIC_LEAF.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLADDERWORT_FLOWER.create(1), ItemPlantDrop.EnumItemPlantDrop.BLADDERWORT_FLOWER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLADDERWORT_STALK.create(1), ItemPlantDrop.EnumItemPlantDrop.BLADDERWORT_STALK_ITEM.create(1));
    }

    private static void registerAnimatorRecipes() {
        AnimatorRecipe.addRecipe(new AnimatorRecipe(ItemMisc.EnumItemMisc.SCROLL.create(1), 16, 16, LootTableRegistry.ANIMATOR_SCROLL){

            @Override
            public ItemStack onAnimated(World world, BlockPos pos, ItemStack stack) {
                LootContext.Builder lootBuilder;
                LootTable lootTable = world.func_184146_ak().func_186521_a(LootTableRegistry.ANIMATOR_SCROLL);
                List loot = lootTable.func_186462_a(world.field_73012_v, (lootBuilder = new LootContext.Builder((WorldServer)world)).func_186471_a());
                if (!loot.isEmpty()) {
                    return (ItemStack)loot.get(world.field_73012_v.nextInt(loot.size()));
                }
                return null;
            }
        });
        AnimatorRecipe.addRecipe(new AnimatorRecipe(ItemMisc.EnumItemMisc.TAR_BEAST_HEART.create(1), 32, 32, ItemMisc.EnumItemMisc.TAR_BEAST_HEART_ANIMATED.create(1)).setRenderEntity("thebetweenlands.tarminion"));
        AnimatorRecipe.addRecipe(new AnimatorRecipe(ItemMisc.EnumItemMisc.INANIMATE_TARMINION.create(1), 8, 8, new ItemStack(ItemRegistry.TARMINION)).setRenderEntity("thebetweenlands.tarminion"));
        AnimatorRecipe.addRecipe(new AnimatorRecipe(new ItemStack(ItemRegistry.TEST_ITEM), 2, 1){

            @Override
            public boolean onRetrieved(World world, BlockPos pos, ItemStack stack) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileEntityAnimator) {
                    TileEntityAnimator animator = (TileEntityAnimator)te;
                    EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, new ItemStack(ItemRegistry.TEST_ITEM));
                    entityitem.field_70159_w = 0.0;
                    entityitem.field_70179_y = 0.0;
                    entityitem.field_70181_x = 0.11000000298023224;
                    world.func_72838_d((Entity)entityitem);
                    animator.func_70299_a(0, null);
                    return false;
                }
                return true;
            }
        });
        AnimatorRecipe.addRecipe(new AnimatorRecipe(new ItemStack(ItemRegistry.SPORES), 8, 4, EntitySporeling.class).setRenderEntity("thebetweenlands.sporeling"));
    }

    private static void registerPurifierRecipes() {
        PurifierRecipe.addRecipe(new ItemStack(BlockRegistry.CRAGROCK, 1, BlockCragrock.EnumCragrockType.DEFAULT.getMetadata()), new ItemStack(BlockRegistry.CRAGROCK, 1, BlockCragrock.EnumCragrockType.MOSSY_1.getMetadata()));
        PurifierRecipe.addRecipe(new ItemStack(BlockRegistry.CRAGROCK, 1, BlockCragrock.EnumCragrockType.DEFAULT.getMetadata()), new ItemStack(BlockRegistry.CRAGROCK, 1, BlockCragrock.EnumCragrockType.MOSSY_2.getMetadata()));
        PurifierRecipe.addRecipe(new ItemStack(ItemRegistry.AQUA_MIDDLE_GEM, 1), new ItemStack(BlockRegistry.AQUA_MIDDLE_GEM_ORE));
        PurifierRecipe.addRecipe(new ItemStack(ItemRegistry.CRIMSON_MIDDLE_GEM, 1), new ItemStack(BlockRegistry.CRIMSON_MIDDLE_GEM_ORE));
        PurifierRecipe.addRecipe(new ItemStack(ItemRegistry.GREEN_MIDDLE_GEM, 1), new ItemStack(BlockRegistry.GREEN_MIDDLE_GEM_ORE));
        PurifierRecipe.addRecipe(new ItemStack(BlockRegistry.PURIFIED_SWAMP_DIRT), new ItemStack(BlockRegistry.SWAMP_DIRT));
        PurifierRecipe.addRecipe(new IPurifierRecipe(){

            @Override
            public boolean matchesInput(ItemStack stack) {
                return stack != null && stack.func_77973_b() == ItemRegistry.WEEDWOOD_ROWBOAT && EntityWeedwoodRowboat.isTarred(stack);
            }

            @Override
            public ItemStack getOutput(ItemStack input) {
                ItemStack output = input.func_77946_l();
                NBTTagCompound compound = output.func_77978_p();
                NBTTagCompound attrs = compound.func_74775_l("attributes");
                attrs.func_82580_o("isTarred");
                if (attrs.func_82582_d()) {
                    compound.func_82580_o("attributes");
                }
                if (compound.func_82582_d()) {
                    output.func_77982_d(null);
                }
                return output;
            }
        });
    }
}

