/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.properties.EntityProperty;
import net.minecraft.world.storage.loot.properties.EntityPropertyManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thebetweenlands.common.entity.loot.LootPropertyFrogType;
import thebetweenlands.common.entity.loot.LootPropertyHasItem;
import thebetweenlands.common.entity.loot.LootPropertyPeatMummyShimmerstone;
import thebetweenlands.common.entity.loot.LootPropertyPyradCharging;

public class LootTableRegistry {
    public static final ResourceLocation COMMON_POT_LOOT = LootTableRegistry.register("loot/common_pot_loot");
    public static final ResourceLocation DUNGEON_CHEST_LOOT = LootTableRegistry.register("loot/dungeon_chest_loot");
    public static final ResourceLocation COMMON_CHEST_LOOT = LootTableRegistry.register("loot/common_chest_loot");
    public static final ResourceLocation DUNGEON_POT_LOOT = LootTableRegistry.register("loot/dungeon_pot_loot");
    public static final ResourceLocation MUSIC_DISC = LootTableRegistry.register("loot/music_disc");
    public static final ResourceLocation ANIMATOR_SCROLL = LootTableRegistry.register("animator/scroll");
    public static final ResourceLocation ANGLER = LootTableRegistry.register("entities/angler");
    public static final ResourceLocation BLIND_CAVE_FISH = LootTableRegistry.register("entities/blind_cave_fish");
    public static final ResourceLocation BLOOD_SNAIL = LootTableRegistry.register("entities/blood_snail");
    public static final ResourceLocation CHIROMAW = LootTableRegistry.register("entities/chiromaw");
    public static final ResourceLocation DARK_DRUID = LootTableRegistry.register("entities/dark_druid");
    public static final ResourceLocation DRAGONFLY = LootTableRegistry.register("entities/dragonfly");
    public static final ResourceLocation FIREFLY = LootTableRegistry.register("entities/firefly");
    public static final ResourceLocation FROG = LootTableRegistry.register("entities/frog");
    public static final ResourceLocation GAS_CLOUD = LootTableRegistry.register("entities/gas_cloud");
    public static final ResourceLocation GECKO = LootTableRegistry.register("entities/gecko");
    public static final ResourceLocation LEECH = LootTableRegistry.register("entities/leech");
    public static final ResourceLocation LURKER = LootTableRegistry.register("entities/lurker");
    public static final ResourceLocation MIRE_SNAIL_EGG = LootTableRegistry.register("entities/mire_snail_egg");
    public static final ResourceLocation MIRE_SNAIL = LootTableRegistry.register("entities/mire_snail");
    public static final ResourceLocation PEAT_MUMMY = LootTableRegistry.register("entities/peat_mummy");
    public static final ResourceLocation PYRAD = LootTableRegistry.register("entities/pyrad");
    public static final ResourceLocation SILT_CRAB = LootTableRegistry.register("entities/silt_crab");
    public static final ResourceLocation SLUDGE = LootTableRegistry.register("entities/sludge");
    public static final ResourceLocation SPORELING = LootTableRegistry.register("entities/sporeling");
    public static final ResourceLocation SWAMP_HAG = LootTableRegistry.register("entities/swamp_hag");
    public static final ResourceLocation TAR_BEAST = LootTableRegistry.register("entities/tar_beast");
    public static final ResourceLocation TARMINION = LootTableRegistry.register("entities/tarminion");
    public static final ResourceLocation TERMITE = LootTableRegistry.register("entities/termite");
    public static final ResourceLocation TOAD = LootTableRegistry.register("entities/toad");
    public static final ResourceLocation WIGHT = LootTableRegistry.register("entities/wight");
    public static final ResourceLocation PROPERTY_FROG_TYPE = LootTableRegistry.register(new LootPropertyFrogType.Serializer());
    public static final ResourceLocation PROPERTY_PEAT_MUMMY_SHIMMERSTONE = LootTableRegistry.register(new LootPropertyPeatMummyShimmerstone.Serializer());
    public static final ResourceLocation PROPERTY_PYRAD_CHARGING = LootTableRegistry.register(new LootPropertyPyradCharging.Serializer());
    public static final ResourceLocation PROPERTY_HAS_ITEM = LootTableRegistry.register(new LootPropertyHasItem.Serializer());

    private static ResourceLocation register(String id) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("thebetweenlands", id));
    }

    private static ResourceLocation register(EntityProperty.Serializer<?> serializer) {
        EntityPropertyManager.func_186644_a(serializer);
        return serializer.func_186649_a();
    }

    public static ArrayList<ItemStack> getItemsFromTable(ResourceLocation lootTable, World world) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        LootTable table = world.func_184146_ak().func_186521_a(lootTable);
        LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)world);
        Field f = ReflectionHelper.findField(LootTable.class, (String[])new String[]{"pools", "field_186466_c", "c"});
        List pools = null;
        try {
            pools = (List)f.get(table);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (pools != null && pools.size() > 0) {
            for (LootPool pool : pools) {
                Field f2 = ReflectionHelper.findField(LootPool.class, (String[])new String[]{"lootEntries", "field_186453_a", "a"});
                List entries = null;
                try {
                    entries = (List)f2.get(pool);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (entries == null || entries.size() <= 0) continue;
                for (LootEntry entry : entries) {
                    if (!(entry instanceof LootEntryItem)) continue;
                    entry.func_186363_a(items, new Random(), lootBuilder.func_186471_a());
                }
            }
        }
        return items;
    }
}

