/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.audio.ambience.AmbienceLayer;
import thebetweenlands.client.audio.ambience.AmbienceManager;
import thebetweenlands.client.audio.ambience.list.CaveAmbienceType;
import thebetweenlands.client.audio.ambience.list.EventAmbienceType;
import thebetweenlands.client.audio.ambience.list.LocationAmbienceType;
import thebetweenlands.client.audio.ambience.list.SurfaceAmbienceType;
import thebetweenlands.client.audio.ambience.list.WaterAmbienceType;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.event.EventBloodSky;
import thebetweenlands.common.world.event.EventSpoopy;
import thebetweenlands.common.world.storage.world.shared.location.LocationAmbience;

@SideOnly(value=Side.CLIENT)
public class AmbienceRegistry {
    public static final AmbienceLayer BASE_LAYER = new AmbienceLayer(new ResourceLocation("base_layer"));

    public static void preInit() {
        AmbienceManager.INSTANCE.registerAmbience(new SurfaceAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new CaveAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new WaterAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new LocationAmbienceType(LocationAmbience.EnumLocationAmbience.WIGHT_TOWER, SoundRegistry.AMBIENT_WIGHT_FORTRESS){

            @Override
            public boolean isActive() {
                return super.isActive() && !this.getAmbience().getLocation().getName().equals("translate:wightTowerBoss");
            }
        });
        AmbienceManager.INSTANCE.registerAmbience(new LocationAmbienceType(LocationAmbience.EnumLocationAmbience.WIGHT_TOWER, SoundRegistry.AMBIENT_WIGHT_FORTRESS){

            @Override
            public boolean isActive() {
                return super.isActive() && this.getAmbience().getLocation().getName().equals("translate:wightTowerBoss");
            }

            @Override
            public float getVolume() {
                return 0.0f;
            }
        });
        AmbienceManager.INSTANCE.registerAmbience(new EventAmbienceType(EventSpoopy.class, SoundRegistry.AMBIENT_SPOOPY, 0));
        AmbienceManager.INSTANCE.registerAmbience(new EventAmbienceType(EventBloodSky.class, SoundRegistry.AMBIENT_BLOOD_SKY, 1).setDelay(140));
    }
}

