/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.purifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.recipes.IPurifierRecipe;
import thebetweenlands.common.recipe.purifier.PurifierRecipeCorrodible;
import thebetweenlands.common.recipe.purifier.PurifierRecipeStandard;

public abstract class PurifierRecipe
implements IPurifierRecipe {
    private static final List<IPurifierRecipe> RECIPES = new ArrayList<IPurifierRecipe>();
    private static final PurifierRecipeCorrodible CORRODIBLE_ITEMS_RECIPE = new PurifierRecipeCorrodible();

    @Override
    public abstract ItemStack getOutput(ItemStack var1);

    @Override
    public abstract boolean matchesInput(ItemStack var1);

    public static void addRecipe(ItemStack output, ItemStack input) {
        RECIPES.add(new PurifierRecipeStandard(output, input));
    }

    public static void addRecipe(IPurifierRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static void removeRecipe(IPurifierRecipe recipe) {
        RECIPES.remove(recipe);
    }

    public static ItemStack getRecipeOutput(ItemStack input) {
        for (IPurifierRecipe recipe : RECIPES) {
            if (!recipe.matchesInput(input)) continue;
            return recipe.getOutput(input);
        }
        return null;
    }

    public static List<IPurifierRecipe> getRecipeList() {
        return Collections.unmodifiableList(RECIPES);
    }

    public static boolean doesInputMatch(ItemStack input, ItemStack toCheck) {
        return PurifierRecipe.doesInputMatch(input, toCheck, false);
    }

    public static boolean doesInputMatch(ItemStack input, ItemStack toCheck, boolean matchStackSize) {
        if (input == null || toCheck == null) {
            return false;
        }
        if (!(input.func_77973_b() != toCheck.func_77973_b() || input.func_77952_i() != Short.MAX_VALUE && input.func_77952_i() != toCheck.func_77952_i() || matchStackSize && input.field_77994_a != toCheck.field_77994_a)) {
            if (input.func_77942_o() && toCheck.func_77942_o()) {
                return input.func_77978_p().equals((Object)toCheck.func_77978_p());
            }
            return input.func_77942_o() == toCheck.func_77942_o();
        }
        return false;
    }

    static {
        PurifierRecipe.addRecipe(CORRODIBLE_ITEMS_RECIPE);
    }
}

