/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.recipes.IDruidAltarRecipe;

public class DruidAltarRecipe
implements IDruidAltarRecipe {
    private static ArrayList<IDruidAltarRecipe> druidAltarRecipes = new ArrayList();
    private ItemStack input1;
    private ItemStack input2;
    private ItemStack input3;
    private ItemStack input4;
    private ItemStack output;

    public DruidAltarRecipe(ItemStack input1, ItemStack input2, ItemStack input3, ItemStack input4, ItemStack output) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.input4 = input4;
        this.output = output;
    }

    public static void addRecipe(IDruidAltarRecipe recipe) {
        druidAltarRecipes.add(recipe);
    }

    public static void addRecipe(ItemStack input1, ItemStack input2, ItemStack input3, ItemStack input4, ItemStack output) {
        druidAltarRecipes.add(new DruidAltarRecipe(input1, input2, input3, input4, output));
    }

    public static void removeRecipe(IDruidAltarRecipe recipe) {
        druidAltarRecipes.remove(recipe);
    }

    public static List<IDruidAltarRecipe> getRecipes() {
        return Collections.unmodifiableList(druidAltarRecipes);
    }

    public static Item getItem(Block block) {
        return Item.func_150898_a((Block)block);
    }

    public static IDruidAltarRecipe getOutput(ItemStack input1, ItemStack input2, ItemStack input3, ItemStack input4) {
        ItemStack[] input = new ItemStack[]{input1, input2, input3, input4};
        for (IDruidAltarRecipe druidAltarRecipe : druidAltarRecipes) {
            if (!druidAltarRecipe.matchesInput(input)) continue;
            return druidAltarRecipe;
        }
        return null;
    }

    public static boolean isValidItem(ItemStack stack) {
        for (IDruidAltarRecipe recipe : druidAltarRecipes) {
            if (!recipe.containsInputItem(stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(ItemStack input, ItemStack toCheck) {
        return toCheck.func_77973_b() == input.func_77973_b() && (input.func_77952_i() == Short.MAX_VALUE || toCheck.func_77952_i() == input.func_77952_i());
    }

    public ArrayList<ItemStack> getInputs() {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        l.add(this.input1);
        l.add(this.input2);
        l.add(this.input3);
        l.add(this.input4);
        return l;
    }

    @Override
    public boolean matchesInput(ItemStack[] input) {
        ArrayList<ItemStack> recipeStacks = new ArrayList<ItemStack>();
        recipeStacks.add(this.input1);
        recipeStacks.add(this.input2);
        recipeStacks.add(this.input3);
        recipeStacks.add(this.input4);
        boolean next = false;
        if (input[0] == null || input[1] == null || input[2] == null || input[3] == null) {
            return false;
        }
        for (ItemStack itemStack : recipeStacks) {
            if (DruidAltarRecipe.matches(itemStack, input[0])) {
                next = true;
                recipeStacks.remove(itemStack);
            }
            if (!next) continue;
            break;
        }
        if (next) {
            next = false;
            for (ItemStack itemStack : recipeStacks) {
                if (DruidAltarRecipe.matches(itemStack, input[1])) {
                    next = true;
                    recipeStacks.remove(itemStack);
                }
                if (!next) continue;
                break;
            }
        }
        if (next) {
            next = false;
            for (ItemStack itemStack : recipeStacks) {
                if (DruidAltarRecipe.matches(itemStack, input[2])) {
                    next = true;
                    recipeStacks.remove(itemStack);
                }
                if (!next) continue;
                break;
            }
        }
        if (next) {
            next = false;
            for (ItemStack itemStack : recipeStacks) {
                if (DruidAltarRecipe.matches(itemStack, input[3])) {
                    next = true;
                    recipeStacks.remove(itemStack);
                }
                if (!next) continue;
                break;
            }
        }
        return next && recipeStacks.size() == 0;
    }

    public ItemStack getDefaultOutput() {
        return this.output;
    }

    @Override
    public ItemStack getOutput(ItemStack[] input) {
        return this.output;
    }

    @Override
    public boolean containsInputItem(ItemStack input) {
        return DruidAltarRecipe.matches(this.input1, input) || DruidAltarRecipe.matches(this.input2, input) || DruidAltarRecipe.matches(this.input3, input) || DruidAltarRecipe.matches(this.input4, input);
    }
}

