/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.recipes.IAnimatorRecipe;
import thebetweenlands.common.tile.TileEntityAnimator;

public class AnimatorRecipe
implements IAnimatorRecipe {
    private final ItemStack input;
    private int requiredFuel;
    private int requiredLife;
    private ItemStack result = null;
    private Class<? extends Entity> spawnEntity = null;
    private String renderEntity = null;
    private Entity renderEntityInstance = null;
    private boolean closeOnFinish = false;
    private ResourceLocation lootTable = null;
    private static final List<IAnimatorRecipe> RECIPES = new ArrayList<IAnimatorRecipe>();

    public AnimatorRecipe(ItemStack input, int requiredFuel, int requiredLife) {
        this.input = input;
        this.requiredFuel = requiredFuel;
        this.requiredLife = requiredLife;
    }

    public AnimatorRecipe(ItemStack input, int requiredFuel, int requiredLife, ResourceLocation lootTable) {
        this.input = input;
        this.requiredFuel = requiredFuel;
        this.requiredLife = requiredLife;
        this.lootTable = lootTable;
    }

    public AnimatorRecipe(ItemStack input, int requiredFuel, int requiredLife, ItemStack result) {
        this(input, requiredFuel, requiredLife);
        this.result = result;
    }

    public AnimatorRecipe(ItemStack input, int requiredFuel, int requiredLife, Class<? extends Entity> result) {
        this(input, requiredFuel, requiredLife);
        this.spawnEntity = result;
        this.closeOnFinish = true;
    }

    public AnimatorRecipe(ItemStack input, int requiredFuel, int requiredLife, ItemStack result, Class<? extends Entity> resultEntity) {
        this(input, requiredFuel, requiredLife);
        this.spawnEntity = resultEntity;
        this.result = result;
        this.closeOnFinish = true;
    }

    public AnimatorRecipe setRenderEntity(String entity) {
        this.renderEntity = entity;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Entity getRenderEntity(ItemStack stack) {
        if (this.renderEntity != null && this.renderEntity.length() > 0) {
            if (this.renderEntityInstance == null) {
                Entity entity;
                this.renderEntityInstance = entity = EntityList.func_75620_a((String)this.renderEntity, (World)null);
            }
            return this.renderEntityInstance;
        }
        return null;
    }

    @Override
    public ItemStack getResult(ItemStack stack) {
        return this.result;
    }

    @Override
    public Class<? extends Entity> getSpawnEntityClass(ItemStack stack) {
        return this.spawnEntity;
    }

    @Override
    public ItemStack onAnimated(World world, BlockPos pos, ItemStack stack) {
        return null;
    }

    @Override
    public boolean onRetrieved(World world, BlockPos pos, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityAnimator) {
            TileEntityAnimator animator = (TileEntityAnimator)te;
            Class<? extends Entity> spawnEntity = this.getSpawnEntityClass(stack);
            if (spawnEntity != null) {
                Entity entity = null;
                try {
                    entity = spawnEntity.getConstructor(World.class).newInstance(world);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return true;
                }
                entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_72838_d(entity);
                animator.func_70299_a(0, null);
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean getCloseOnFinish(ItemStack stack) {
        return this.closeOnFinish;
    }

    public AnimatorRecipe setCloseOnFinish(boolean close) {
        this.closeOnFinish = close;
        return this;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        return this.input.func_77952_i() == Short.MAX_VALUE ? this.input.func_77973_b() == stack.func_77973_b() : this.input.func_77973_b() == stack.func_77973_b() && this.input.func_77952_i() == stack.func_77952_i();
    }

    @Override
    public int getRequiredFuel(ItemStack stack) {
        return this.requiredFuel;
    }

    @Override
    public int getRequiredLife(ItemStack stack) {
        return this.requiredLife;
    }

    public static void addRecipe(IAnimatorRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static void removeRecipe(IAnimatorRecipe recipe) {
        RECIPES.remove(recipe);
    }

    public static List<IAnimatorRecipe> getRecipes() {
        return RECIPES;
    }

    public static IAnimatorRecipe getRecipe(ItemStack input) {
        if (input != null) {
            for (IAnimatorRecipe recipe : AnimatorRecipe.getRecipes()) {
                if (!recipe.matchesInput(input)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Deprecated
    public static IAnimatorRecipe getRecipeFromOutput(ItemStack output) {
        return null;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }
}

