/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.custom;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thebetweenlands.api.recipes.IAnimatorRecipe;
import thebetweenlands.common.recipe.custom.CustomRecipes;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;
import thebetweenlands.common.tile.TileEntityAnimator;

public class CustomAnimatorRecipes
extends CustomRecipes<IAnimatorRecipe> {
    public CustomAnimatorRecipes() {
        super("animator", ImmutableMap.of((Object)"input/item", CustomRecipes.RecipeArg.ITEM_INPUT, (Object)"input/fuel", CustomRecipes.RecipeArg.INT, (Object)"input/life", CustomRecipes.RecipeArg.INT), ImmutableMap.of((Object)"output", CustomRecipes.RecipeArg.ITEM_OUTPUT, (Object)"output_entity", CustomRecipes.RecipeArg.ENTITY, (Object)"rendered_entity", CustomRecipes.RecipeArg.STRING));
    }

    @Override
    public IAnimatorRecipe load() {
        AnimatorRecipe recipe;
        ItemStack output;
        ItemStack input = (ItemStack)((CustomRecipes.IRecipeEntry)this.get("input/item", CustomRecipes.RecipeArg.ITEM_INPUT).get()).create();
        Optional<CustomRecipes.IRecipeEntry<ItemStack>> outputItem = this.get("output", CustomRecipes.RecipeArg.ITEM_OUTPUT);
        final Optional<CustomRecipes.IRecipeEntry<Entity>> outputEntity = this.get("output_entity", CustomRecipes.RecipeArg.ENTITY);
        Optional<CustomRecipes.IRecipeEntry<String>> renderedEntity = this.get("rendered_entity", CustomRecipes.RecipeArg.STRING);
        int fuel = (Integer)((CustomRecipes.IRecipeEntry)this.get("input/fuel", CustomRecipes.RecipeArg.INT).get()).create();
        int life = (Integer)((CustomRecipes.IRecipeEntry)this.get("input/life", CustomRecipes.RecipeArg.INT).get()).create();
        if (!outputItem.isPresent() && !outputEntity.isPresent()) {
            this.throwException("At least one output item or entity must be specified");
        }
        ItemStack itemStack = output = outputItem.isPresent() ? (ItemStack)((CustomRecipes.IRecipeEntry)outputItem.get()).create() : null;
        if (outputEntity.isPresent()) {
            recipe = new AnimatorRecipe(input, fuel, life, output){

                @Override
                public boolean onRetrieved(World world, BlockPos pos, ItemStack stack) {
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof TileEntityAnimator) {
                        TileEntityAnimator animator = (TileEntityAnimator)te;
                        animator.func_70299_a(0, output == null ? null : output.func_77946_l());
                        Entity entity = (Entity)((CustomRecipes.IRecipeEntry)outputEntity.get()).create(world, new Vec3d((Vec3i)pos), null);
                        if (entity != null) {
                            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                            world.func_72838_d(entity);
                            return false;
                        }
                        return true;
                    }
                    return true;
                }
            }.setCloseOnFinish(true);
            if (renderedEntity.isPresent()) {
                recipe.setRenderEntity((String)((CustomRecipes.IRecipeEntry)renderedEntity.get()).create());
            }
        } else {
            recipe = new AnimatorRecipe(input, fuel, life, output);
        }
        return recipe;
    }

    @Override
    public CustomRecipes.IRecipeRegistrar<IAnimatorRecipe> createRegistrar() {
        return new CustomRecipes.IRecipeRegistrar<IAnimatorRecipe>(){

            @Override
            public boolean register(IAnimatorRecipe recipe) {
                AnimatorRecipe.addRecipe(recipe);
                return true;
            }

            @Override
            public boolean unregister(IAnimatorRecipe recipe) {
                AnimatorRecipe.removeRecipe(recipe);
                return true;
            }
        };
    }
}

