/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.serverbound;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.capability.equipment.EquipmentHelper;
import thebetweenlands.common.network.MessageEntity;
import thebetweenlands.common.registries.CapabilityRegistry;

public class MessageEquipItem
extends MessageEntity {
    private int sourceSlot;
    private int mode;
    private EnumEquipmentInventory inventory;

    public MessageEquipItem() {
    }

    public MessageEquipItem(int sourceSlot, Entity target) {
        this.addEntity(target);
        this.sourceSlot = sourceSlot;
        this.mode = 0;
    }

    public MessageEquipItem(Entity target, EnumEquipmentInventory inventory, int slot) {
        this.addEntity(target);
        this.sourceSlot = slot;
        this.inventory = inventory;
        this.mode = 1;
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.writeInt(this.mode);
        switch (this.mode) {
            default: {
                buf.writeInt(this.sourceSlot);
                break;
            }
            case 1: {
                buf.writeInt(this.sourceSlot);
                buf.writeInt(this.inventory.id);
            }
        }
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        super.deserialize(buf);
        this.mode = buf.readInt();
        switch (this.mode) {
            default: {
                this.sourceSlot = buf.readInt();
                break;
            }
            case 1: {
                this.sourceSlot = buf.readInt();
                this.inventory = EnumEquipmentInventory.fromID(buf.readInt());
            }
        }
    }

    @Override
    public IMessage process(MessageContext ctx) {
        super.process(ctx);
        if (ctx.getServerHandler() != null) {
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            Entity target = this.getEntity(0);
            if (target != null && target.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
                switch (this.mode) {
                    default: {
                        if (this.sourceSlot < 0 || this.sourceSlot >= sender.field_71071_by.func_70302_i_()) break;
                        ItemStack stack = sender.field_71071_by.func_70301_a(this.sourceSlot);
                        ItemStack result = EquipmentHelper.equipItem((EntityPlayer)sender, target, stack, false);
                        if (sender.field_71075_bZ.field_75098_d) break;
                        sender.field_71071_by.func_70299_a(this.sourceSlot, result);
                        break;
                    }
                    case 1: {
                        ItemStack stack;
                        if (this.sourceSlot < 0 || (stack = EquipmentHelper.unequipItem((EntityPlayer)sender, target, this.inventory, this.sourceSlot, false)) == null || sender.field_71071_by.func_70441_a(stack)) break;
                        target.func_70099_a(stack, target.func_70047_e());
                    }
                }
            }
        }
        return null;
    }
}

