/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.SharedStorage;

public class MessageSyncSharedStorage
extends MessageBase {
    private NBTTagCompound nbt;

    public MessageSyncSharedStorage() {
    }

    public MessageSyncSharedStorage(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        try {
            this.nbt = buf.func_150793_b();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_150786_a(this.nbt);
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        SharedStorage sharedStorage;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld((World)world);
        SharedStorage loadedStorage = worldStorage.getSharedStorage((sharedStorage = SharedStorage.load(worldStorage, this.nbt, null, true)).getID());
        if (loadedStorage != null && sharedStorage.getLinkedChunks().isEmpty()) {
            worldStorage.removeSharedStorage(loadedStorage);
        } else if (loadedStorage != null && sharedStorage.getClass() == loadedStorage.getClass()) {
            loadedStorage.readFromPacketNBT(sharedStorage.writeToPacketNBT(new NBTTagCompound()));
        } else {
            if (loadedStorage != null) {
                worldStorage.removeSharedStorage(loadedStorage);
            }
            worldStorage.addSharedStorage(sharedStorage);
        }
    }
}

