/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.EnvironmentEvent;
import thebetweenlands.common.world.event.EnvironmentEventRegistry;

public class MessageSyncEnvironmentEvent
extends MessageBase {
    private EnvironmentEvent event;
    private String eventName;
    private boolean active;
    private PacketBuffer receivedBuffer;

    public MessageSyncEnvironmentEvent() {
    }

    public MessageSyncEnvironmentEvent(EnvironmentEvent eevent) {
        this.event = eevent;
        this.eventName = eevent.getEventName();
        this.active = eevent.isActive();
    }

    @Override
    public void serialize(PacketBuffer buffer) {
        buffer.func_180714_a(this.eventName);
        buffer.writeBoolean(this.active);
        PacketBuffer pkt = new PacketBuffer((ByteBuf)buffer);
        this.event.sendEventPacket(pkt);
    }

    @Override
    public void deserialize(PacketBuffer buffer) {
        this.receivedBuffer = buffer;
        this.eventName = buffer.func_150789_c(128);
        this.active = buffer.readBoolean();
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.handleMessage();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleMessage() {
        WorldProviderBetweenlands provider;
        EnvironmentEventRegistry eeRegistry;
        EnvironmentEvent eevent;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world.field_73011_w instanceof WorldProviderBetweenlands && (eevent = (eeRegistry = (provider = (WorldProviderBetweenlands)world.field_73011_w).getWorldData().getEnvironmentEventRegistry()).forName(this.eventName)) != null) {
            eevent.loadEventPacket(new PacketBuffer((ByteBuf)this.receivedBuffer));
            eevent.setActive(this.active, false);
            eevent.setLoaded();
        }
    }
}

