/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.world.storage.chunk.ChunkDataBase;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;

public class MessageSyncChunkData
extends MessageBase {
    private int chunkX;
    private int chunkZ;
    private NBTTagCompound nbt;

    public MessageSyncChunkData() {
    }

    public MessageSyncChunkData(Chunk chunk, NBTTagCompound nbt) {
        this.chunkX = chunk.field_76635_g;
        this.chunkZ = chunk.field_76647_h;
        this.nbt = nbt;
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)buf);
        try {
            this.nbt = packetBuffer.func_150793_b();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.chunkX);
        buf.writeInt(this.chunkZ);
        PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)buf);
        packetBuffer.func_150786_a(this.nbt);
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.updateChunks(this.chunkX, this.chunkZ, this.nbt);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateChunks(int chunkX, int chunkZ, NBTTagCompound nbt) {
        Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_72863_F().func_186026_b(chunkX, chunkZ);
        if (chunk != null) {
            ChunkDataBase.updateHandlerData(BetweenlandsWorldData.forWorld((World)Minecraft.func_71410_x().field_71441_e), chunk, nbt);
        }
    }
}

