/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.audio.EntitySound;
import thebetweenlands.common.network.MessageEntity;

public class MessagePlayEntityIdle
extends MessageEntity {
    private SoundEvent sound;
    private SoundCategory category;
    private float soundVolume;
    private float soundPitch;

    public MessagePlayEntityIdle() {
    }

    public MessagePlayEntityIdle(Entity entity, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        this.addEntity(entity);
        this.sound = sound;
        this.category = category;
        this.soundVolume = volume;
        this.soundPitch = pitch;
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        super.deserialize(buf);
        this.sound = (SoundEvent)SoundEvent.field_187505_a.func_148754_a(buf.func_150792_a());
        this.category = (SoundCategory)buf.func_179257_a(SoundCategory.class);
        this.soundVolume = buf.readFloat();
        this.soundPitch = buf.readFloat();
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.func_150787_b(SoundEvent.field_187505_a.func_148757_b((Object)this.sound));
        buf.func_179249_a((Enum)this.category);
        buf.writeFloat(this.soundVolume);
        buf.writeFloat(this.soundPitch);
    }

    @Override
    public IMessage process(MessageContext ctx) {
        super.process(ctx);
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        Entity entity = this.getEntity(0);
        if (entity != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a(new EntitySound<Entity>(this.sound, this.category, entity, e -> e.func_70089_S()));
        }
    }
}

