/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.DruidAltarSoundHandler;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityDruidAltar;

public class MessageDruidAltarProgress
extends MessageBase {
    private BlockPos pos;
    private int progress;

    public MessageDruidAltarProgress() {
    }

    public MessageDruidAltarProgress(TileEntityDruidAltar tile) {
        this.pos = tile.func_174877_v();
        this.progress = tile.craftingProgress;
    }

    public MessageDruidAltarProgress(TileEntityDruidAltar tile, int progress) {
        this.pos = tile.func_174877_v();
        this.progress = progress;
    }

    @Override
    public void serialize(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeInt(this.progress);
    }

    @Override
    public void deserialize(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.progress = buffer.readInt();
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void handle() {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof TileEntityDruidAltar) {
            TileEntityDruidAltar altar = (TileEntityDruidAltar)te;
            if (this.progress >= 0) {
                altar.craftingProgress = this.progress;
            } else if (this.progress == -1) {
                for (int x = -8; x <= 8; ++x) {
                    for (int y = -8; y <= 8; ++y) {
                        for (int z = -8; z <= 8; ++z) {
                            BlockPos pos = te.func_174877_v().func_177982_a(x, y, z);
                            Block block = world.func_180495_p(pos).func_177230_c();
                            if (block != BlockRegistry.DRUID_STONE_1 && block != BlockRegistry.DRUID_STONE_2 && block != BlockRegistry.DRUID_STONE_3 && block != BlockRegistry.DRUID_STONE_4 && block != BlockRegistry.DRUID_STONE_5) continue;
                            BLParticles.ALTAR_CRAFTING.spawn((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withScale(0.25f + te.func_145831_w().field_73012_v.nextFloat() * 0.2f)).withData(te));
                        }
                    }
                }
                DruidAltarSoundHandler.playAltarSound(altar);
            } else if (this.progress == -2) {
                DruidAltarSoundHandler.stopAltarSound(altar);
            }
        }
    }
}

