/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.SharedStorage;
import thebetweenlands.common.world.storage.world.shared.location.LocationGuarded;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;

public class MessageClearBlockGuard
extends MessageBase {
    private String id;

    public MessageClearBlockGuard() {
    }

    public MessageClearBlockGuard(LocationStorage location) {
        this.id = location.getID();
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.id = buf.func_150789_c(256);
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_180714_a(this.id);
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        LocationGuarded location;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld((World)world);
        SharedStorage storage = worldStorage.getSharedStorage(this.id);
        if (storage != null && storage instanceof LocationGuarded && (location = (LocationGuarded)storage).getGuard() != null) {
            location.getGuard().clear((World)world);
        }
    }
}

