/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.SharedStorage;
import thebetweenlands.common.world.storage.world.shared.location.LocationGuarded;
import thebetweenlands.common.world.storage.world.shared.location.guard.BlockLocationGuard;

public class MessageBlockGuardSectionChange
extends MessageBase {
    private String id;
    private BlockPos pos;
    private byte[] data;

    public MessageBlockGuardSectionChange() {
    }

    public MessageBlockGuardSectionChange(SharedStorage storage, BlockPos pos, BlockLocationGuard.GuardChunkSection section) {
        this.id = storage.getID();
        this.pos = pos;
        if (section.getBlockRefCount() > 0) {
            this.data = new byte[512];
            section.writeData(this.data);
        } else {
            this.data = null;
        }
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.id = buf.func_150789_c(256);
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        if (!buf.readBoolean()) {
            this.data = buf.func_189425_b(512);
            if (this.data.length != 512) {
                throw new RuntimeException("Invalid block guard data");
            }
        } else {
            this.data = null;
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_180714_a(this.id);
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.data == null);
        if (this.data != null) {
            buf.func_179250_a(this.data);
        }
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        LocationGuarded location;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld((World)world);
        SharedStorage storage = worldStorage.getSharedStorage(this.id);
        if (storage != null && storage instanceof LocationGuarded && (location = (LocationGuarded)storage).getGuard() != null) {
            BlockLocationGuard.GuardChunkSection section = location.getGuard().getSection(this.pos);
            if (this.data != null) {
                location.getGuard().setGuarded((World)world, this.pos, true);
                section = location.getGuard().getSection(this.pos);
                if (section != null) {
                    section.loadData(this.data);
                }
            } else if (section != null) {
                section.clear();
            }
        }
    }
}

