/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.network.MessageBase;

public abstract class MessageEntity
extends MessageBase {
    private List<EntityIdentifier> entityIdentifiers = new ArrayList<EntityIdentifier>();

    public void addEntity(Entity entity) {
        this.entityIdentifiers.add(new EntityIdentifier(entity.func_145782_y(), entity.field_71093_bK, entity));
    }

    @Nullable
    public Entity getEntity(int index) {
        EntityIdentifier id;
        if (index < this.entityIdentifiers.size() && (id = this.entityIdentifiers.get(index)) != null) {
            return id.entity;
        }
        return null;
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (EntityIdentifier id : this.entityIdentifiers) {
            if (id.entity == null) continue;
            entities.add(id.entity);
        }
        return entities;
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeByte(this.entityIdentifiers.size());
        for (EntityIdentifier id : this.entityIdentifiers) {
            buf.writeInt(id.entityID);
            buf.writeInt(id.dimensionId);
        }
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.entityIdentifiers.clear();
        int entities = buf.readByte();
        for (int i = 0; i < entities; ++i) {
            this.entityIdentifiers.add(new EntityIdentifier(buf.readInt(), buf.readInt(), null));
        }
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.processClient();
        } else {
            for (EntityIdentifier id : this.entityIdentifiers) {
                WorldServer world = DimensionManager.getWorld((int)id.dimensionId);
                if (world == null) continue;
                id.entity = world.func_73045_a(id.entityID);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void processClient() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (EntityIdentifier id : this.entityIdentifiers) {
            if (id.dimensionId != world.field_73011_w.getDimension()) continue;
            id.entity = world.func_73045_a(id.entityID);
        }
    }

    private static class EntityIdentifier {
        private int entityID;
        private int dimensionId;
        private Entity entity;

        private EntityIdentifier(int id, int dim, Entity entity) {
            this.entityID = id;
            this.dimensionId = dim;
            this.entity = entity;
        }
    }
}

