/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools.bow;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemBLBow
extends ItemBow
implements ICorrodible {
    public ItemBLBow() {
        this.field_77777_bU = 1;
        this.func_77656_e(600);
        this.func_77637_a(BLCreativeTabs.GEARS);
        CorrosionHelper.addCorrosionPropertyOverrides((Item)this);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemStack = entityIn.func_184607_cu();
                return itemStack != null && itemStack == stack ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
    }

    protected ItemStack findArrows(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(stack)) continue;
            return stack;
        }
        return null;
    }

    protected boolean func_185058_h_(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemArrow;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean infiniteArrows = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack arrow = this.findArrows(player);
            int usedTicks = this.func_77626_a(stack) - timeLeft;
            if ((usedTicks = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)usedTicks, (arrow != null || infiniteArrows ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (arrow != null || infiniteArrows) {
                if (arrow == null) {
                    arrow = new ItemStack(ItemRegistry.ANGLER_TOOTH_ARROW);
                }
                float strength = ItemBLBow.getArrowVelocity(usedTicks);
                if ((strength *= CorrosionHelper.getModifier(stack)) >= 0.1f) {
                    if (!world.field_72995_K) {
                        int k;
                        int j;
                        ItemArrow itemArrow = (ItemArrow)arrow.func_77973_b();
                        EntityArrow entityArrow = itemArrow.func_185052_a(world, arrow, (EntityLivingBase)player);
                        entityArrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, strength * 3.0f, 1.0f);
                        if (strength == 1.0f) {
                            entityArrow.func_70243_d(true);
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            entityArrow.func_70239_b(entityArrow.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            entityArrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityArrow.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        if (infiniteArrows) {
                            entityArrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        world.func_72838_d((Entity)entityArrow);
                    }
                    world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + strength * 0.5f);
                    if (!infiniteArrows) {
                        --arrow.field_77994_a;
                        if (arrow.field_77994_a == 0) {
                            player.field_71071_by.func_184437_d(arrow);
                        }
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    public static float getArrowVelocity(int charge) {
        float strength = (float)charge / 20.0f;
        if ((strength = (strength * strength + strength * 2.0f) / 3.0f * 1.15f) > 1.0f) {
            strength = 1.0f;
        }
        return strength;
    }

    public int func_77626_a(ItemStack stack) {
        return 100000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        boolean flag = this.findArrows(playerIn) != null;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStackIn, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn) : new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return CorrosionHelper.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return CorrosionHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return CorrosionHelper.getStrVsBlock(super.func_150893_a(stack, state), stack, state);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        CorrosionHelper.updateCorrosion(itemStack, world, holder, slot, isHeldItem);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> lines, boolean advancedItemTooltips) {
        CorrosionHelper.addCorrosionTooltips(itemStack, player, lines, advancedItemTooltips);
    }
}

