/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.elixir.ElixirRecipe;
import thebetweenlands.common.herblore.elixir.ElixirRecipes;

public class ItemWeedwoodBucketInfusion
extends Item {
    public ItemWeedwoodBucketInfusion() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        if (this.hasTag(stack)) {
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("infused") && stack.func_77978_p().func_74764_b("ingredients") && stack.func_77978_p().func_74764_b("infusionTime")) {
                int infusionTime = stack.func_77978_p().func_74762_e("infusionTime");
                String infusionTimeSeconds = BigDecimal.valueOf((float)infusionTime / 20.0f).setScale(1, 4).toPlainString();
                list.add(TextFormatting.GREEN + "Infusion time: " + TextFormatting.RESET + infusionTimeSeconds);
                list.add(TextFormatting.GREEN + "Ingredients:");
                NBTTagList nbtList = (NBTTagList)stack.func_77978_p().func_74781_a("ingredients");
                LinkedHashMap stackMap = new LinkedHashMap();
                for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                    ItemStack ingredient = ItemStack.func_77949_a((NBTTagCompound)nbtList.func_150305_b(i));
                    boolean contained = false;
                    for (Map.Entry stackCount : stackMap.entrySet()) {
                        if (!ItemStack.func_77989_b((ItemStack)((ItemStack)stackCount.getKey()), (ItemStack)ingredient)) continue;
                        stackMap.put(stackCount.getKey(), (Integer)stackCount.getValue() + 1);
                        contained = true;
                    }
                    if (contained) continue;
                    stackMap.put(ingredient, 1);
                }
                for (Map.Entry stackCount : stackMap.entrySet()) {
                    ItemStack ingredient = (ItemStack)stackCount.getKey();
                    int count = (Integer)stackCount.getValue();
                    if (ingredient == null) continue;
                    list.add((count > 1 ? count + "x " : "") + ingredient.func_82833_r());
                    List<Aspect> ingredientAspects = AspectManager.get(TheBetweenlands.proxy.getClientWorld()).getDiscoveredAspects(AspectManager.getAspectItem(ingredient), DiscoveryContainer.getMergedDiscoveryContainer(player));
                    if (ingredientAspects.size() < 1 || !Keyboard.isKeyDown((int)42)) continue;
                    for (Aspect aspect : ingredientAspects) {
                        list.add("  - " + aspect.type.getName() + " (" + aspect.getDisplayAmount() * (float)count + ")");
                    }
                }
            } else {
                list.add("This Infusion Contains Nothing");
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        stack.func_77982_d(new NBTTagCompound());
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }

    public ElixirRecipe getInfusionElixirRecipe(ItemStack stack) {
        return ElixirRecipes.getFromAspects(this.getInfusingAspects(stack));
    }

    public List<IAspectType> getInfusingAspects(ItemStack stack) {
        ArrayList<IAspectType> infusingAspects = new ArrayList<IAspectType>();
        if (this.hasTag(stack) && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("infused") && stack.func_77978_p().func_74764_b("ingredients") && stack.func_77978_p().func_74764_b("infusionTime")) {
            NBTTagList nbtList = (NBTTagList)stack.func_77978_p().func_74781_a("ingredients");
            LinkedHashMap stackMap = new LinkedHashMap();
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                ItemStack ingredient = ItemStack.func_77949_a((NBTTagCompound)nbtList.func_150305_b(i));
                infusingAspects.addAll(AspectManager.get(TheBetweenlands.proxy.getClientWorld()).getDiscoveredAspectTypes(AspectManager.getAspectItem(ingredient), null));
            }
        }
        return infusingAspects;
    }

    public int getInfusionTime(ItemStack stack) {
        if (this.hasTag(stack) && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("infused") && stack.func_77978_p().func_74764_b("ingredients") && stack.func_77978_p().func_74764_b("infusionTime")) {
            int infusionTime = stack.func_77978_p().func_74762_e("infusionTime");
            return infusionTime;
        }
        return 0;
    }

    private int getColorFromRGBA(float r, float g, float b, float a) {
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }
}

