/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.item.tools.ItemBLBucketFilled;

public class ItemSpecificBucket
extends ItemBLBucketFilled {
    protected final FluidStack fluidStack;
    private static final Map<Item, List<Fluid>> BUCKETS = new HashMap<Item, List<Fluid>>();

    public ItemSpecificBucket(Item empty, Fluid fluid) {
        super(empty);
        this.fluidStack = new FluidStack(fluid, 1000);
        MinecraftForge.EVENT_BUS.register((Object)this);
        List<Fluid> lst = BUCKETS.get(empty);
        if (lst == null) {
            lst = new ArrayList<Fluid>();
            BUCKETS.put(empty, lst);
        }
        lst.add(fluid);
    }

    public static boolean hasSpecificBucket(Item empty, Fluid fluid) {
        List<Fluid> lst = BUCKETS.get(empty);
        if (lst != null) {
            return lst.contains(fluid);
        }
        return false;
    }

    public FluidStack getFluid(ItemStack container) {
        return this.fluidStack.copy();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack((Item)this));
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        FluidStack fluidStack;
        ItemStack emptyBucket = event.getEmptyBucket();
        if (emptyBucket == null || !emptyBucket.func_77969_a(this.getEmpty()) || this.isNbtSensitive() && ItemStack.func_77970_a((ItemStack)emptyBucket, (ItemStack)this.getEmpty())) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = target.func_178782_a();
        ItemStack singleBucket = emptyBucket.func_77946_l();
        singleBucket.field_77994_a = 1;
        IFluidHandler targetFluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        if (targetFluidHandler != null && (fluidStack = targetFluidHandler.drain(this.fluidStack, false)) != null && fluidStack.amount == this.fluidStack.amount && fluidStack.getFluid() == this.fluidStack.getFluid()) {
            fluidStack = targetFluidHandler.drain(this.fluidStack, true);
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(new ItemStack((Item)this));
            event.setCanceled(false);
        }
    }
}

