/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.common.entity.EntityShockwaveBlock;
import thebetweenlands.common.item.tools.ItemBLSword;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemShockwaveSword
extends ItemBLSword
implements ICorrodible {
    private static final ImmutableList<String> STACK_NBT_EXCLUSIONS = ImmutableList.of((Object)"cooldown");

    public ItemShockwaveSword(Item.ToolMaterial material) {
        super(material);
        this.func_185043_a(new ResourceLocation("charging"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return stack.func_77978_p() != null && stack.func_77978_p().func_74762_e("cooldown") < 60 ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedItemTooltips) {
        super.func_77624_a(stack, player, list, advancedItemTooltips);
        list.add(I18n.func_135052_a((String)"tooltip.shockwaveSword.usage", (Object[])new Object[0]));
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeldItem) {
        CorrosionHelper.updateCorrosion(stack, world, entity, slot, isHeldItem);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("cooldown")) {
            stack.func_77978_p().func_74768_a("cooldown", 0);
        }
        if (!stack.func_77978_p().func_74764_b("uses")) {
            stack.func_77978_p().func_74768_a("uses", 0);
        }
        if (stack.func_77978_p().func_74762_e("uses") == 3) {
            if (stack.func_77978_p().func_74762_e("cooldown") < 60) {
                stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") + 1);
            }
            if (stack.func_77978_p().func_74762_e("cooldown") >= 60) {
                stack.func_77978_p().func_74768_a("cooldown", 60);
                stack.func_77978_p().func_74768_a("uses", 0);
            }
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return EnumActionResult.PASS;
        }
        if (stack.func_77978_p().func_74762_e("uses") < 3) {
            if (!world.field_72995_K) {
                stack.func_77972_a(2, (EntityLivingBase)player);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.SHOCKWAVE_SWORD, SoundCategory.BLOCKS, 1.0f, 2.0f);
                double direction = Math.toRadians(player.field_70177_z);
                Vec3d diag = new Vec3d(Math.sin(direction + 1.5707963267948966), 0.0, Math.cos(direction + 1.5707963267948966)).func_72432_b();
                ArrayList<BlockPos> spawnedPos = new ArrayList<BlockPos>();
                for (int distance = -1; distance <= 16; ++distance) {
                    block1: for (int distance2 = -distance; distance2 <= distance; ++distance2) {
                        for (int yo = -1; yo <= 1; ++yo) {
                            int originZ;
                            int originY;
                            int originX = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + 0.5 - Math.sin(direction) * (double)distance - diag.field_72450_a * (double)distance2 * 0.25));
                            BlockPos origin = new BlockPos(originX, originY = pos.func_177956_o() + yo, originZ = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + 0.5 + Math.cos(direction) * (double)distance + diag.field_72449_c * (double)distance2 * 0.25)));
                            if (spawnedPos.contains(origin)) continue;
                            spawnedPos.add(origin);
                            IBlockState block = world.func_180495_p(new BlockPos(originX, originY, originZ));
                            if (block == null || !block.func_185915_l() || block.func_177230_c().hasTileEntity(block) || !(block.func_185887_b(world, origin) <= 5.0f) || !(block.func_185887_b(world, origin) >= 0.0f) || world.func_180495_p(origin.func_177984_a()).func_185914_p()) continue;
                            stack.func_77978_p().func_74768_a("blockID", Block.func_149682_b((Block)world.func_180495_p(origin).func_177230_c()));
                            stack.func_77978_p().func_74768_a("blockMeta", world.func_180495_p(origin).func_177230_c().func_176201_c(world.func_180495_p(origin)));
                            EntityShockwaveBlock shockwaveBlock = new EntityShockwaveBlock(world);
                            shockwaveBlock.setOrigin(origin, MathHelper.func_76128_c((double)Math.sqrt(distance * distance + distance2 * distance2)), (double)pos.func_177958_n() + 0.5, (double)pos.func_177952_p() + 0.5, (Entity)player);
                            shockwaveBlock.func_70012_b((double)originX + 0.5, originY, (double)originZ + 0.5, 0.0f, 0.0f);
                            shockwaveBlock.setBlock(Block.func_149729_e((int)stack.func_77978_p().func_74762_e("blockID")), stack.func_77978_p().func_74762_e("blockMeta"));
                            world.func_72838_d((Entity)shockwaveBlock);
                            continue block1;
                        }
                    }
                }
                stack.func_77978_p().func_74768_a("uses", stack.func_77978_p().func_74762_e("uses") + 1);
                if (stack.func_77978_p().func_74762_e("uses") >= 3) {
                    stack.func_77978_p().func_74768_a("uses", 3);
                    stack.func_77978_p().func_74768_a("cooldown", 0);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean wasCharging = oldStack.func_77978_p() != null && oldStack.func_77978_p().func_74762_e("cooldown") < 60;
        boolean isCharging = newStack.func_77978_p() != null && newStack.func_77978_p().func_74762_e("cooldown") < 60;
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && !isCharging || isCharging != wasCharging || !NBTHelper.areItemStackTagsEqual(oldStack, newStack, STACK_NBT_EXCLUSIONS);
    }
}

