/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.common.registries.BlockRegistry;

public class ItemBLShovel
extends ItemSpade
implements ICorrodible {
    public ItemBLShovel(Item.ToolMaterial material) {
        super(material);
        CorrosionHelper.addCorrosionPropertyOverrides((Item)this);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return CorrosionHelper.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return CorrosionHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return CorrosionHelper.getStrVsBlock(super.func_150893_a(stack, state), stack, state);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        CorrosionHelper.updateCorrosion(itemStack, world, holder, slot, isHeldItem);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return CorrosionHelper.getAttributeModifiers((Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack), slot, stack, ItemTool.field_111210_e, this.field_77865_bY);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> lines, boolean advancedItemTooltips) {
        CorrosionHelper.addCorrosionTooltips(itemStack, player, lines, advancedItemTooltips);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing == EnumFacing.UP) {
            boolean dug = false;
            IBlockState blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c() == BlockRegistry.COARSE_SWAMP_DIRT) {
                world.func_175656_a(pos, BlockRegistry.DUG_SWAMP_DIRT.func_176223_P());
                dug = true;
            }
            if (blockState.func_177230_c() == BlockRegistry.SWAMP_DIRT) {
                world.func_175656_a(pos, BlockRegistry.DUG_SWAMP_DIRT.func_176223_P());
                dug = true;
            }
            if (blockState.func_177230_c() == BlockRegistry.SWAMP_GRASS) {
                world.func_175656_a(pos, BlockRegistry.DUG_SWAMP_GRASS.func_176223_P());
                dug = true;
            }
            if (blockState.func_177230_c() == BlockRegistry.PURIFIED_SWAMP_DIRT) {
                world.func_175656_a(pos, BlockRegistry.DUG_PURIFIED_SWAMP_DIRT.func_176223_P());
                dug = true;
            }
            if (dug) {
                if (world.field_72995_K) {
                    for (int i = 0; i < 80; ++i) {
                        world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)pos.func_177958_n() + 0.5f), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f), (double)((world.field_73012_v.nextFloat() - 0.5f) * 0.1f), (double)(world.field_73012_v.nextFloat() * 0.3f), (double)((world.field_73012_v.nextFloat() - 0.5f) * 0.1f), new int[]{Block.func_176210_f((IBlockState)blockState)});
                    }
                }
                SoundType sound = blockState.func_177230_c().getSoundType(blockState, world, pos, (Entity)player);
                for (int i = 0; i < 3; ++i) {
                    world.func_184148_a(null, (double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ), sound.func_185845_c(), SoundCategory.PLAYERS, 1.0f, 0.5f + world.field_73012_v.nextFloat() * 0.5f);
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }
}

