/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemBLShield
extends ItemShield {
    private Item.ToolMaterial material;

    public ItemBLShield(Item.ToolMaterial material) {
        this.material = material;
        this.func_77656_e(material.func_77997_a() * 2);
        this.func_77637_a(BLCreativeTabs.GEARS);
    }

    public String func_77653_i(ItemStack stack) {
        return ("" + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return BLCreativeTabs.GEARS;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (this.material == BLMaterialRegistry.TOOL_WEEDWOOD) {
            return repair.func_77973_b() == Item.func_150898_a((Block)BlockRegistry.WEEDWOOD);
        }
        if (this.material == BLMaterialRegistry.TOOL_BONE) {
            return repair.func_77973_b() == Item.func_150898_a((Block)BlockRegistry.BETWEENSTONE);
        }
        if (this.material == BLMaterialRegistry.TOOL_OCTINE) {
            return repair.func_77973_b() == ItemRegistry.OCTINE_INGOT;
        }
        if (this.material == BLMaterialRegistry.TOOL_VALONITE) {
            return ItemMisc.EnumItemMisc.VALONITE_SHARD.isItemOf(repair);
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int getShieldBlockingCooldown(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        return 0;
    }

    public void onAttackBlocked(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        EntityLivingBase attacker;
        ItemStack activeItem;
        if (!attacked.field_70170_p.field_72995_K && source.func_76346_g() instanceof EntityLivingBase && (activeItem = (attacker = (EntityLivingBase)source.func_76346_g()).func_184607_cu()) != null && activeItem.func_77973_b() instanceof ItemAxe) {
            float attackStrength = attacker instanceof EntityPlayer ? ((EntityPlayer)attacker).func_184825_o(0.5f) : 1.0f;
            float criticalChance = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)attacker) * 0.05f;
            if (attacker.func_70051_ag() && attackStrength > 0.9f) {
                criticalChance += 0.75f;
            }
            if (attacked.field_70170_p.field_73012_v.nextFloat() < criticalChance) {
                if (attacked instanceof EntityPlayer) {
                    ((EntityPlayer)attacked).func_184811_cZ().func_185145_a((Item)this, 100);
                    attacked.func_184597_cx();
                }
                attacked.field_70170_p.func_72960_a((Entity)attacked, (byte)30);
            }
        }
    }

    public float getBlockedDamage(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        float multiplier = 0.4f - Math.min(this.material.func_78000_c() / 3.0f, 1.0f) * 0.4f;
        return Math.min(damage * multiplier, 8.0f);
    }

    public float getDefenderKnockbackMultiplier(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        return 0.6f - Math.min((float)this.material.func_77997_a() / 2500.0f, 1.0f) * 0.6f;
    }

    public float getAttackerKnockbackMultiplier(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        return 0.6f;
    }

    public static enum EventHandler {
        INSTANCE;


        @SubscribeEvent
        public void onLivingAttacked(LivingAttackEvent event) {
            EntityLivingBase attacked = event.getEntityLiving();
            if (attacked.func_184607_cu() != null && attacked.func_184607_cu().func_77973_b() instanceof ItemBLShield && this.canBlockDamageSource(attacked, event.getSource())) {
                int cooldown;
                float attackerKbMultiplier;
                if (!attacked.field_70170_p.field_72995_K) {
                    event.setCanceled(true);
                }
                EnumHand activeHand = attacked.func_184600_cs();
                ItemStack stack = attacked.func_184607_cu();
                ItemBLShield shield = (ItemBLShield)stack.func_77973_b();
                if (!attacked.field_70170_p.field_72995_K) {
                    attacked.func_184597_cx();
                    float defenderKbMultiplier = shield.getDefenderKnockbackMultiplier(stack, attacked, event.getAmount(), event.getSource());
                    float newDamage = shield.getBlockedDamage(stack, attacked, event.getAmount(), event.getSource());
                    if (newDamage > 0.0f) {
                        double prevMotionX = attacked.field_70159_w;
                        double prevMotionY = attacked.field_70181_x;
                        double prevMotionZ = attacked.field_70179_y;
                        attacked.func_70097_a(event.getSource(), newDamage);
                        attacked.field_70159_w = prevMotionX;
                        attacked.field_70181_x = prevMotionY;
                        attacked.field_70179_y = prevMotionZ;
                    }
                    double prevMotionY = attacked.field_70181_x;
                    attacked.func_70653_a(event.getSource().func_76346_g(), defenderKbMultiplier, event.getSource().func_76364_f().field_70165_t - attacked.field_70165_t, event.getSource().func_76364_f().field_70161_v - attacked.field_70161_v);
                    attacked.field_70181_x = prevMotionY;
                    attacked.field_70133_I = true;
                    attacked.field_70170_p.func_72960_a((Entity)attacked, (byte)29);
                    attacked.func_184598_c(activeHand);
                }
                if (!attacked.field_70170_p.field_72995_K && event.getSource().func_76364_f() instanceof EntityLivingBase && (attackerKbMultiplier = shield.getAttackerKnockbackMultiplier(stack, attacked, event.getAmount(), event.getSource())) > 0.0f) {
                    ((EntityLivingBase)event.getSource().func_76364_f()).func_70653_a((Entity)attacked, attackerKbMultiplier, attacked.field_70165_t - event.getSource().func_76364_f().field_70165_t, attacked.field_70161_v - event.getSource().func_76364_f().field_70161_v);
                }
                if (attacked instanceof EntityPlayer && (cooldown = shield.getShieldBlockingCooldown(stack, (EntityLivingBase)((EntityPlayer)attacked), event.getAmount(), event.getSource())) > 0) {
                    ((EntityPlayer)attacked).func_184811_cZ().func_185145_a((Item)shield, cooldown);
                    attacked.func_184597_cx();
                }
                shield.onAttackBlocked(stack, attacked, event.getAmount(), event.getSource());
                if (!attacked.field_70170_p.field_72995_K) {
                    int itemDamage = 1 + MathHelper.func_76141_d((float)event.getAmount());
                    stack.func_77972_a(itemDamage, attacked);
                    if (stack.field_77994_a <= 0) {
                        EnumHand enumhand = attacked.func_184600_cs();
                        if (attacked instanceof EntityPlayer) {
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)((EntityPlayer)attacked), (ItemStack)stack, (EnumHand)enumhand);
                        }
                        if (enumhand == EnumHand.MAIN_HAND) {
                            attacked.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                        } else {
                            attacked.func_184201_a(EntityEquipmentSlot.OFFHAND, null);
                        }
                        attacked.field_70170_p.func_72960_a((Entity)attacked, (byte)30);
                    }
                }
            }
        }

        protected boolean canBlockDamageSource(EntityLivingBase attacked, DamageSource damageSourceIn) {
            Vec3d vec3d;
            if (!damageSourceIn.func_76363_c() && attacked.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
                Vec3d vec3d1 = attacked.func_70676_i(1.0f);
                Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(attacked.field_70165_t, attacked.field_70163_u, attacked.field_70161_v)).func_72432_b();
                vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
                if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                    return true;
                }
            }
            return false;
        }
    }
}

