/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.tools.ItemSpecificBucket;

public class ItemBLBucketFilled
extends UniversalBucket {
    public ItemBLBucketFilled(Item empty) {
        super(1000, new ItemStack(empty), false);
        this.func_77637_a(BLCreativeTabs.GEARS);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidBucketWrapperFixed(stack);
    }

    public String func_77667_c(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        String key = this.getEmpty().func_77977_a() + "." + (fluidStack == null ? "unknown" : fluidStack.getFluid().getUnlocalizedName(fluidStack));
        return key;
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        String fluidLocalizedStr = fluidStack == null ? "unknown" : fluidStack.getLocalizedName();
        String fullUnlocalizedFluidBucketKey = this.getEmpty().func_77977_a() + "." + (fluidStack == null ? "unknown" : fluidStack.getUnlocalizedName());
        return I18n.func_94522_b((String)(fullUnlocalizedFluidBucketKey + ".name")) ? I18n.func_74838_a((String)(fullUnlocalizedFluidBucketKey + ".name")).trim() : I18n.func_74837_a((String)(this.getEmpty().func_77977_a() + ".full.name"), (Object[])new Object[]{fluidLocalizedStr});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fs;
            ItemStack stack;
            if (fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA || fluid.getName().equals("milk") || ItemSpecificBucket.hasSpecificBucket(this.getEmpty().func_77973_b(), fluid) || this.fill(stack = new ItemStack((Item)this), fs = new FluidStack(fluid, this.getCapacity()), true) != fs.amount) continue;
            subItems.add(stack);
        }
    }

    private static final class FluidBucketWrapperFixed
    extends FluidBucketWrapper {
        public FluidBucketWrapperFixed(ItemStack container) {
            super(container);
        }

        @Nullable
        public FluidStack getFluid() {
            Item item = this.container.func_77973_b();
            if (item == Items.field_151131_as) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (item == Items.field_151129_at) {
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
            if (item == Items.field_151117_aB) {
                return FluidRegistry.getFluidStack((String)"milk", (int)1000);
            }
            if (item instanceof UniversalBucket) {
                UniversalBucket bucket = (UniversalBucket)item;
                return bucket.getFluid(this.container);
            }
            return null;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            if (fluid.getFluid() == FluidRegistry.WATER || fluid.getFluid() == FluidRegistry.LAVA || fluid.getFluid().getName().equals("milk")) {
                return true;
            }
            return FluidRegistry.getBucketFluids().contains(fluid.getFluid());
        }

        protected void setFluid(Fluid fluid) {
            if (fluid == null && this.container.func_77973_b() instanceof UniversalBucket) {
                this.container.deserializeNBT(((UniversalBucket)this.container.func_77973_b()).getEmpty().func_77955_b(new NBTTagCompound()));
            } else if (FluidRegistry.getBucketFluids().contains(fluid) && this.container.func_77973_b() instanceof UniversalBucket) {
                ItemStack filledBucket = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)fluid);
                this.container.deserializeNBT(filledBucket.serializeNBT());
            } else {
                super.setFluid(fluid);
            }
        }
    }
}

