/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityInfuser;

public abstract class ItemBLBucketEmpty
extends Item {
    public ItemBLBucketEmpty() {
        this.func_77637_a(BLCreativeTabs.GEARS);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        IFluidHandler handler;
        FluidStack drained;
        TileEntityInfuser tile;
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)playerIn, (World)worldIn, (ItemStack)itemStackIn, (RayTraceResult)raytraceresult);
        if (ret != null) {
            return ret;
        }
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        BlockPos blockpos = raytraceresult.func_178782_a();
        if (!worldIn.func_175660_a(playerIn, blockpos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        if (!playerIn.func_175151_a(blockpos.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, itemStackIn)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (!worldIn.field_72995_K && block == BlockRegistry.INFUSER && playerIn.func_70093_af() && (tile = (TileEntityInfuser)worldIn.func_175625_s(blockpos)) != null && tile.hasInfusion() && tile.getWaterAmount() >= 1000) {
            ItemStack infusionBucket = new ItemStack(ItemRegistry.WEEDWOOD_BUCKET_INFUSION);
            NBTTagCompound nbtCompound = new NBTTagCompound();
            infusionBucket.func_77982_d(nbtCompound);
            nbtCompound.func_74778_a("infused", "Infused");
            NBTTagList nbtList = new NBTTagList();
            for (int i = 0; i < tile.func_70302_i_() - 1; ++i) {
                ItemStack stackInSlot = tile.func_70301_a(i);
                if (stackInSlot == null) continue;
                nbtList.func_74742_a((NBTBase)stackInSlot.func_77955_b(new NBTTagCompound()));
            }
            nbtCompound.func_74782_a("ingredients", (NBTBase)nbtList);
            nbtCompound.func_74768_a("infusionTime", tile.getInfusionTime());
            tile.extractFluids(new FluidStack((Fluid)FluidRegistry.SWAMP_WATER, 1000));
            if (itemStackIn.field_77994_a == 1) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)infusionBucket);
            }
            playerIn.func_71019_a(infusionBucket.func_77946_l(), false);
            --itemStackIn.field_77994_a;
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        if (block instanceof IFluidBlock) {
            Fluid fluid = ((IFluidBlock)block).getFluid();
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 11);
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
            playerIn.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillBucket(itemStackIn, playerIn, fluid));
        }
        TileEntity te = worldIn.func_175625_s(blockpos);
        if (te != null && te instanceof IFluidHandler && (drained = (handler = (IFluidHandler)te).drain(1000, false)) != null && drained.amount == 1000) {
            drained = handler.drain(1000, true);
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
            playerIn.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillBucket(itemStackIn, playerIn, drained.getFluid()));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    private ItemStack fillBucket(ItemStack emptyBuckets, EntityPlayer player, Fluid fluid) {
        ItemStack fullBucket = UniversalBucket.getFilledBucket((UniversalBucket)this.getFilledBucket(), (Fluid)fluid);
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        if (--emptyBuckets.field_77994_a <= 0) {
            return fullBucket.func_77946_l();
        }
        if (!player.field_71071_by.func_70441_a(fullBucket.func_77946_l())) {
            player.func_71019_a(fullBucket.func_77946_l(), false);
        }
        return emptyBuckets;
    }

    protected abstract UniversalBucket getFilledBucket();
}

