/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.location.EnumLocationType;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;

public class LocationDebugItem
extends Item {
    public LocationDebugItem() {
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        block9: {
            BetweenlandsWorldData worldStorage;
            block10: {
                if (world.field_72995_K) break block9;
                worldStorage = BetweenlandsWorldData.forWorld(world);
                if (!playerIn.func_70093_af()) break block10;
                List<LocationStorage> locations = worldStorage.getSharedStorageAt(LocationStorage.class, location -> location.isInside((Vec3i)pos), pos.func_177958_n(), pos.func_177952_p());
                if (locations.isEmpty()) {
                    int rndID = world.field_73012_v.nextInt();
                    LocationStorage location2 = new LocationStorage(worldStorage, UUID.randomUUID().toString(), SharedRegion.getFromBlockPos(pos), "Test Location ID: " + rndID, EnumLocationType.NONE);
                    location2.addBounds(new AxisAlignedBB(pos).func_72314_b(16.0, 16.0, 16.0));
                    location2.setSeed(world.field_73012_v.nextLong());
                    location2.linkChunks();
                    location2.setDirty(true);
                    worldStorage.addSharedStorage(location2);
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(String.format("Added new location: %s", location2.getName())));
                } else {
                    for (LocationStorage location3 : locations) {
                        worldStorage.removeSharedStorage(location3);
                    }
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(String.format("Removed %s locations:", locations.size())));
                    for (LocationStorage location3 : locations) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentString("  " + location3.getName()));
                    }
                }
                break block9;
            }
            List<LocationStorage> locations = worldStorage.getSharedStorageAt(LocationStorage.class, location -> location.isInside((Vec3i)pos), pos.func_177958_n(), pos.func_177952_p());
            ArrayList<EntityPlayerMP> watchers = new ArrayList<EntityPlayerMP>();
            boolean guard = false;
            for (LocationStorage location4 : locations) {
                if (hand != EnumHand.OFF_HAND || location4.getGuard() == null) continue;
                boolean guarded = location4.getGuard().isGuarded(world, (Entity)playerIn, pos);
                location4.getGuard().setGuarded(world, pos, !guarded);
                playerIn.func_145747_a((ITextComponent)new TextComponentString(String.format("Set block guard to %s at %s for location %s", !guarded, "X=" + pos.func_177958_n() + " Y=" + pos.func_177956_o() + " Z=" + pos.func_177952_p(), location4.getName())));
                location4.setDirty(true, true);
                guard = true;
            }
            if (guard) break block9;
            for (LocationStorage location4 : locations) {
                location4.unlinkAllChunks();
                location4.linkChunks();
                location4.setDirty(true, true);
                for (EntityPlayerMP watcher : location4.getWatchers()) {
                    if (watchers.contains(watcher)) continue;
                    watchers.add(watcher);
                }
            }
            playerIn.func_145747_a((ITextComponent)new TextComponentString(String.format("Marked %s locations as dirty and queued update packets to %s watchers:", locations.size(), watchers.size())));
            playerIn.func_145747_a((ITextComponent)new TextComponentString("  Locations:"));
            for (LocationStorage location4 : locations) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("    " + location4.getName()));
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("      Guarded at %s, %s: %s", new Object[]{new TextComponentTranslation(world.func_180495_p(pos).func_177230_c().func_149739_a() + ".name", new Object[0]), "X=" + pos.func_177958_n() + " Y=" + pos.func_177956_o() + " Z=" + pos.func_177952_p(), location4.getGuard() == null ? String.valueOf(false) : Boolean.valueOf(location4.getGuard().isGuarded(world, (Entity)playerIn, pos))}));
                playerIn.func_145747_a((ITextComponent)new TextComponentString("      Watchers:"));
                for (EntityPlayerMP watcher : location4.getWatchers()) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("        " + watcher.func_70005_c_()));
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

