/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thebetweenlands.common.item.IGenericItem;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.gen.feature.structure.WorldGenWeedwoodPortalTree;

public class ItemSwampTalisman
extends Item
implements ItemRegistry.ISingleJsonSubItems {
    public ItemSwampTalisman() {
        this.func_77656_e(0);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (EnumTalisman type : EnumTalisman.values()) {
            list.add(type.create(1));
        }
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return "item.thebetweenlands." + IGenericItem.getFromStack(EnumTalisman.class, stack).getUnlocalizedName();
        }
        catch (Exception e) {
            return "item.thebetweenlands.unknownTalisman";
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (!playerIn.func_175151_a(pos, facing, stack)) {
                return EnumActionResult.FAIL;
            }
            if (EnumTalisman.SWAMP_TALISMAN_0.isItemOf(stack)) {
                Block block = worldIn.func_180495_p(pos).func_177230_c();
                if (this.isBlockSapling(block)) {
                    if (new WorldGenWeedwoodPortalTree().func_180709_b(worldIn, field_77697_d, pos)) {
                        worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)SoundRegistry.PORTAL_ACTIVATE, SoundCategory.PLAYERS, 0.5f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                        playerIn.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, playerIn.field_70177_z, playerIn.field_70125_A);
                    } else {
                        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("talisman.noplace", new Object[0]));
                    }
                }
                stack.func_77972_a(1, (EntityLivingBase)playerIn);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    protected boolean isBlockSapling(Block block) {
        if (block instanceof BlockSapling) {
            return true;
        }
        List dict = OreDictionary.getOres((String)"treeSapling");
        for (ItemStack stack : dict) {
            if (!(stack.func_77973_b() instanceof ItemBlock) || ((ItemBlock)stack.func_77973_b()).func_179223_d() != block) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getTypes() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumTalisman type : EnumTalisman.values()) {
            models.add(type.name());
        }
        return models;
    }

    public static enum EnumTalisman implements IGenericItem
    {
        SWAMP_TALISMAN_0,
        SWAMP_TALISMAN_1,
        SWAMP_TALISMAN_2,
        SWAMP_TALISMAN_3,
        SWAMP_TALISMAN_4;

        private final String unlocalizedName;
        private final String modelName = this.name().toLowerCase(Locale.ENGLISH);

        private EnumTalisman() {
            this.unlocalizedName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.modelName);
        }

        @Override
        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        @Override
        public String getModelName() {
            return this.modelName;
        }

        @Override
        public int getID() {
            return this.ordinal();
        }

        @Override
        public Item getItem() {
            return ItemRegistry.SWAMP_TALISMAN;
        }
    }
}

