/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.util.NBTHelper;

public class ItemShimmerStone
extends Item {
    private static final int MAX_SHIMMER_TICKS = 8;

    public ItemShimmerStone() {
        this.func_77637_a(BLCreativeTabs.ITEMS);
        this.func_185043_a(new ResourceLocation("shimmer"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return NBTHelper.getStackNBTSafe(stack).func_74767_n("shimmering") ? 1.0f : 0.0f;
            }
        });
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        this.updateShimmer(stack, world.field_73012_v);
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.updateShimmer(entityItem.func_92059_d(), entityItem.field_70170_p.field_73012_v);
        return super.onEntityItemUpdate(entityItem);
    }

    protected void updateShimmer(ItemStack stack, Random rand) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        boolean shimmer = nbt.func_74767_n("shimmering");
        if (!shimmer) {
            if (rand.nextInt(30) == 0) {
                nbt.func_74757_a("shimmering", true);
            }
        } else {
            int ticks = nbt.func_74762_e("shimmeringTicks");
            if (ticks < 8) {
                nbt.func_74768_a("shimmeringTicks", ticks + 1);
            } else {
                nbt.func_74757_a("shimmering", false);
                nbt.func_74768_a("shimmeringTicks", 0);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            double px = player.field_70165_t;
            double py = player.field_70163_u + (double)player.func_70047_e();
            double pz = player.field_70161_v;
            px -= (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            float strength = 0.8f;
            double mx = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * strength;
            double mz = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * strength;
            double my = -MathHelper.func_76126_a((float)((player.field_70125_A - 8.0f) / 180.0f * (float)Math.PI)) * strength;
            EntityItem itemEntity = new EntityItem(world, px, py -= 0.25, pz -= (double)(MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f), new ItemStack((Item)this));
            itemEntity.field_70159_w = mx;
            itemEntity.field_70181_x = my;
            itemEntity.field_70179_y = mz;
            itemEntity.func_174867_a(20);
            world.func_72838_d((Entity)itemEntity);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

