/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.herblore.ItemCrushed;
import thebetweenlands.common.item.herblore.ItemPlantDrop;
import thebetweenlands.common.registries.BlockRegistry;

public class ItemOctineIngot
extends Item {
    public ItemOctineIngot() {
        this.func_77637_a(BLCreativeTabs.ITEMS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> info, boolean debug) {
        info.add(I18n.func_135052_a((String)"tooltip.octine.fire", (Object[])new Object[0]));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        RayTraceResult result = this.func_77621_a(worldIn, playerIn, true);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos offsetPos = result.func_178782_a().func_177972_a(result.field_178784_b);
            boolean hasTinder = false;
            boolean isBlockTinder = false;
            IBlockState blockState = worldIn.func_180495_p(result.func_178782_a());
            if (this.isTinder(blockState, null)) {
                hasTinder = true;
                isBlockTinder = true;
            } else {
                List tinder = worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB(offsetPos), entity -> entity.func_92059_d() != null && this.isTinder(null, entity.func_92059_d()));
                if (!tinder.isEmpty()) {
                    hasTinder = true;
                }
            }
            if ((hasTinder || isBlockTinder) && blockState.func_177230_c() != Blocks.field_150480_ab) {
                playerIn.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase playerIn, int count) {
        World worldIn;
        RayTraceResult result;
        if (playerIn instanceof EntityPlayer && (result = this.func_77621_a(worldIn = playerIn.field_70170_p, (EntityPlayer)playerIn, true)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = result.func_178782_a();
            BlockPos offsetPos = pos.func_177972_a(result.field_178784_b);
            boolean hasTinder = false;
            boolean isBlockTinder = false;
            IBlockState blockState = worldIn.func_180495_p(pos);
            if (this.isTinder(blockState, null)) {
                hasTinder = true;
                isBlockTinder = true;
            } else {
                List tinder = worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB(offsetPos), entity -> entity.func_92059_d() != null && this.isTinder(null, entity.func_92059_d()));
                if (!tinder.isEmpty()) {
                    hasTinder = true;
                }
            }
            if (hasTinder) {
                if (worldIn.field_73012_v.nextInt(count / 10 + 1) == 0) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, result.field_72307_f.field_72450_a + (double)worldIn.field_73012_v.nextFloat() * 0.2 - 0.1, result.field_72307_f.field_72448_b + (double)worldIn.field_73012_v.nextFloat() * 0.2 - 0.1, result.field_72307_f.field_72449_c + (double)worldIn.field_73012_v.nextFloat() * 0.2 - 0.1, 0.0, 0.1, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, result.field_72307_f.field_72450_a + (double)worldIn.field_73012_v.nextFloat() * 0.2 - 0.1, result.field_72307_f.field_72448_b + (double)worldIn.field_73012_v.nextFloat() * 0.2 - 0.1, result.field_72307_f.field_72449_c + (double)worldIn.field_73012_v.nextFloat() * 0.2 - 0.1, 0.0, 0.1, 0.0, new int[0]);
                }
                if (!worldIn.field_72995_K && count <= 1) {
                    if (isBlockTinder) {
                        worldIn.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                    } else if (worldIn.func_180495_p(offsetPos).func_185904_a().func_76222_j()) {
                        worldIn.func_175656_a(offsetPos, Blocks.field_150480_ab.func_176223_P());
                    }
                    worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    protected boolean isTinder(IBlockState blockState, ItemStack stack) {
        if (blockState != null) {
            Block block = blockState.func_177230_c();
            return block == BlockRegistry.CAVE_MOSS || block == BlockRegistry.MOSS || block == BlockRegistry.LICHEN || block == BlockRegistry.THORNS;
        }
        if (stack != null) {
            if (stack.func_77973_b() instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                return this.isTinder(itemBlock.func_179223_d().func_176223_P(), null);
            }
            return ItemPlantDrop.EnumItemPlantDrop.CAVE_MOSS_ITEM.isItemOf(stack) || ItemPlantDrop.EnumItemPlantDrop.MOSS_ITEM.isItemOf(stack) || ItemPlantDrop.EnumItemPlantDrop.LICHEN_ITEM.isItemOf(stack) || ItemPlantDrop.EnumItemPlantDrop.THORNS_ITEM.isItemOf(stack) || ItemCrushed.EnumItemCrushed.GROUND_CAVE_MOSS.isItemOf(stack) || ItemCrushed.EnumItemCrushed.GROUND_MOSS.isItemOf(stack) || ItemCrushed.EnumItemCrushed.GROUND_LICHEN.isItemOf(stack) || ItemCrushed.EnumItemCrushed.GROUND_THORNS.isItemOf(stack);
        }
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }
}

