/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.herblore;

import com.google.common.base.CaseFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.item.IGenericItem;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemPlantDrop
extends Item
implements ItemRegistry.ISubItemsItem {
    public ItemPlantDrop() {
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (EnumItemPlantDrop type : EnumItemPlantDrop.values()) {
            list.add(type.create(1));
        }
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return "item.thebetweenlands." + IGenericItem.getFromStack(EnumItemPlantDrop.class, stack).getUnlocalizedName();
        }
        catch (Exception e) {
            return "item.thebetweenlands.unknownPlantDrop";
        }
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        for (EnumItemPlantDrop type : EnumItemPlantDrop.values()) {
            models.put(type.getID(), new ResourceLocation("thebetweenlands", type.getModelName()));
        }
        return models;
    }

    public static enum EnumItemPlantDrop implements IGenericItem
    {
        GENERIC_LEAF(0),
        ALGAE_ITEM(1),
        ARROW_ARUM_LEAF(2),
        BLUE_EYED_GRASS_FLOWERS(3),
        BLUE_IRIS_PETAL(4),
        MIRE_CORAL_ITEM(5),
        DEEP_WATER_CORAL_ITEM(6),
        BOG_BEAN_FLOWER_ITEM(7),
        BONESET_FLOWERS(8),
        BOTTLE_BRUSH_GRASS_BLADES(9),
        BROOM_SEDGE_LEAVES(10),
        BUTTON_BUSH_FLOWERS(11),
        CARDINAL_FLOWER_PETALS(12),
        CATTAIL_HEAD(13),
        CAVE_GRASS_BLADES(14),
        COPPER_IRIS_PETALS(15),
        GOLDEN_CLUB_FLOWER_ITEM(16),
        LICHEN_ITEM(17),
        MARSH_HIBISCUS_FLOWER(18),
        MARSH_MALLOW_FLOWER(19),
        MARSH_MARIGOLD_FLOWER_ITEM(20),
        NETTLE_LEAF(21),
        PHRAGMITE_STEMS(22),
        PICKEREL_WEED_FLOWER(23),
        SHOOT_LEAVES(24),
        SLUDGECREEP_LEAVES(25),
        SOFT_RUSH_LEAVES(26),
        SUNDEW_HEAD(27),
        SWAMP_TALL_GRASS_BLADES(28),
        CAVE_MOSS_ITEM(29),
        MOSS_ITEM(30),
        MILKWEED_ITEM(31),
        HANGER_ITEM(32),
        PITCHER_PLANT_TRAP(33),
        WATER_WEEDS_ITEM(34),
        VENUS_FLY_TRAP_ITEM(35),
        VOLARPAD_ITEM(36),
        THORNS_ITEM(37),
        POISON_IVY_ITEM(38),
        BLADDERWORT_STALK_ITEM(39),
        BLADDERWORT_FLOWER_ITEM(40);

        private final int id;
        private final String unlocalizedName;
        private final String modelName;

        private EnumItemPlantDrop(int id) {
            this.id = id;
            this.modelName = this.name().toLowerCase(Locale.ENGLISH);
            this.unlocalizedName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.modelName);
        }

        @Override
        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        @Override
        public String getModelName() {
            return this.modelName;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public Item getItem() {
            return ItemRegistry.ITEMS_PLANT_DROP;
        }
    }
}

