/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.capability.ISummoningCapability;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.entity.mobs.EntityMummyArm;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.KeyBindRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemRingOfSummoning
extends ItemRing {
    public static final int MAX_USE_TIME = 100;
    public static final int USE_COOLDOWN = 120;
    public static final int MAX_ARMS = 32;

    public ItemRingOfSummoning() {
        this.func_77656_e(256);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips) {
        list.add(I18n.func_135052_a((String)"tooltip.ring.summoning.bonus", (Object[])new Object[0]));
        if (Keyboard.isKeyDown((int)42)) {
            String toolTip = I18n.func_135052_a((String)"tooltip.ring.summoning", (Object[])new Object[]{KeyBindRegistry.RADIAL_MENU.getDisplayName(), KeyBindRegistry.USE_RING.getDisplayName()});
            list.addAll(ItemTooltipHandler.splitTooltip(toolTip, 1));
        } else {
            list.add(I18n.func_135052_a((String)"tooltip.press.shift", (Object[])new Object[0]));
        }
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer && entity.hasCapability(CapabilityRegistry.CAPABILITY_SUMMON, null)) {
            ISummoningCapability cap = (ISummoningCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_SUMMON, null);
            NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
            if (cap.getCooldownTicks() > 0) {
                cap.setCooldownTicks(cap.getCooldownTicks() - 1);
                nbt.func_74757_a("ringActive", false);
            } else if (cap.isActive()) {
                cap.setActiveTicks(cap.getActiveTicks() + 1);
                nbt.func_74757_a("ringActive", true);
                if (cap.getActiveTicks() > 100) {
                    cap.setActive(false);
                    cap.setCooldownTicks(120);
                } else {
                    int arms = entity.field_70170_p.func_175647_a(EntityMummyArm.class, entity.func_174813_aQ().func_72314_b(18.0, 18.0, 18.0), e -> (double)e.func_70032_d(entity) <= 18.0).size();
                    if (arms < 32) {
                        List targets = entity.field_70170_p.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), e -> e instanceof EntityLiving && (double)e.func_70032_d(entity) <= 16.0 && e != entity);
                        BlockPos targetPos = null;
                        if (!targets.isEmpty()) {
                            boolean isAttacked;
                            EntityLivingBase target = (EntityLivingBase)targets.get(entity.field_70170_p.field_73012_v.nextInt(targets.size()));
                            boolean bl = isAttacked = !entity.field_70170_p.func_72872_a(EntityMummyArm.class, target.func_174813_aQ()).isEmpty();
                            if (!isAttacked) {
                                targetPos = target.func_180425_c();
                            }
                        }
                        if (targetPos == null && entity.field_70170_p.field_73012_v.nextInt(3) == 0) {
                            boolean isAttacked;
                            targetPos = entity.func_180425_c().func_177982_a(entity.field_70170_p.field_73012_v.nextInt(16) - 8, entity.field_70170_p.field_73012_v.nextInt(6) - 3, entity.field_70170_p.field_73012_v.nextInt(16) - 8);
                            boolean bl = isAttacked = !entity.field_70170_p.func_72872_a(EntityMummyArm.class, new AxisAlignedBB(targetPos)).isEmpty();
                            if (isAttacked) {
                                targetPos = null;
                            }
                        }
                        if (targetPos != null && entity.field_70170_p.func_180495_p(targetPos.func_177977_b()).isSideSolid((IBlockAccess)entity.field_70170_p, targetPos.func_177977_b(), EnumFacing.UP)) {
                            EntityMummyArm arm = new EntityMummyArm(entity.field_70170_p);
                            arm.func_70012_b((double)targetPos.func_177958_n() + 0.5, targetPos.func_177956_o(), (double)targetPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                            if (arm.field_70170_p.func_184144_a((Entity)arm, arm.func_174813_aQ()).isEmpty()) {
                                this.drainPower(stack, entity);
                                arm.setOwner(entity);
                                entity.field_70170_p.func_72838_d((Entity)arm);
                            }
                        }
                    }
                }
            } else {
                nbt.func_74757_a("ringActive", false);
            }
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a("ringActive", false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("ringActive");
    }

    public static boolean isRingActive(Entity entity) {
        if (entity.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
            IEquipmentCapability cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            IInventory inv = cap.getInventory(EnumEquipmentInventory.RING);
            boolean hasRing = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ItemRegistry.RING_OF_SUMMONING || !((ItemRing)stack.func_77973_b()).canBeUsed(stack)) continue;
                hasRing = true;
                break;
            }
            return hasRing;
        }
        return false;
    }
}

