/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.capability.IPuppeteerCapability;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.KeyBindRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemRingOfRecruitment
extends ItemRing {
    public ItemRingOfRecruitment() {
        this.func_77656_e(450);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips) {
        list.add(I18n.func_135052_a((String)"tooltip.ring.recruitment.bonus", (Object[])new Object[0]));
        if (Keyboard.isKeyDown((int)42)) {
            String toolTip = I18n.func_135052_a((String)"tooltip.ring.recruitment", (Object[])new Object[]{KeyBindRegistry.RADIAL_MENU.getDisplayName()});
            list.addAll(ItemTooltipHandler.splitTooltip(toolTip, 1));
        } else {
            list.add(I18n.func_135052_a((String)"tooltip.press.shift", (Object[])new Object[0]));
        }
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            int tickRate = 80;
            if (entity.hasCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) {
                IPuppeteerCapability cap = (IPuppeteerCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null);
                int puppets = cap.getPuppets().size();
                NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
                if (puppets == 0) {
                    tickRate = 0;
                    nbt.func_74757_a("ringActive", false);
                } else {
                    tickRate = (int)Math.max(1.0, 30.0 - Math.pow(puppets, 0.5) * 14.0);
                    nbt.func_74757_a("ringActive", true);
                }
            }
            if (tickRate > 0 && entity.field_70173_aa % tickRate == 0) {
                this.removeXp((EntityPlayer)entity, 1);
            }
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a("ringActive", false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("ringActive");
    }

    public static boolean isRingActive(Entity entity) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71067_cb <= 0) {
            return false;
        }
        if (entity.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
            IEquipmentCapability cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            IInventory inv = cap.getInventory(EnumEquipmentInventory.RING);
            boolean hasRing = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ItemRegistry.RING_OF_RECRUITMENT) continue;
                hasRing = true;
                break;
            }
            return hasRing;
        }
        return false;
    }
}

