/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;

public class ItemRing
extends Item
implements IEquippable {
    public ItemRing() {
        this.func_77625_d(1);
        this.func_77637_a(BLCreativeTabs.SPECIALS);
        IEquippable.addEquippedPropertyOverrides(this);
    }

    public boolean canBeUsed(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k();
    }

    protected float getXPConversionRate(ItemStack stack, EntityPlayer player) {
        return 5.0f;
    }

    public void drainPower(ItemStack stack, Entity entity) {
        if (stack.func_77952_i() < stack.func_77958_k() && stack.func_77973_b() instanceof ItemRing && ((ItemRing)stack.func_77973_b()).canBeUsed(stack)) {
            stack.func_77964_b(stack.func_77952_i() + 1);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af() && stack.func_77952_i() > 0 && player.field_71067_cb > 0) {
            if (!world.field_72995_K) {
                int repairPerClick = 40;
                float conversion = this.getXPConversionRate(stack, player);
                float requiredRepair = Math.min((float)repairPerClick, (float)stack.func_77952_i() / conversion);
                stack.func_77964_b(Math.max(0, stack.func_77952_i() - MathHelper.func_76123_f((float)((float)Math.min(repairPerClick, player.field_71067_cb) * conversion))));
                this.removeXp(player, MathHelper.func_76123_f((float)Math.min(requiredRepair, (float)player.field_71067_cb)));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    protected void removeXp(EntityPlayer player, int amount) {
        int newXP = Math.max(player.field_71067_cb - amount, 0);
        player.field_71067_cb = 0;
        player.field_71068_ca = 0;
        player.field_71106_cc = 0.0f;
        if (newXP > 0) {
            int xpCap = Integer.MAX_VALUE - player.field_71067_cb;
            if (newXP > xpCap) {
                newXP = xpCap;
            }
            player.field_71106_cc += (float)newXP / (float)player.func_71050_bK();
            player.field_71067_cb += newXP;
            while (player.field_71106_cc >= 1.0f) {
                player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
                ++player.field_71068_ca;
                player.field_71106_cc /= (float)player.func_71050_bK();
            }
        }
    }

    @Override
    public EnumEquipmentInventory getEquipmentCategory(ItemStack stack) {
        return EnumEquipmentInventory.RING;
    }

    @Override
    public boolean canEquipOnRightClick(ItemStack stack, EntityPlayer player, Entity target) {
        return stack.func_77952_i() == 0 || player.field_71067_cb == 0 || player.func_70093_af();
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityPlayer player, Entity target) {
        return target instanceof EntityPlayer;
    }

    @Override
    public boolean canUnequip(ItemStack stack, EntityPlayer player, Entity target, IInventory inventory) {
        return true;
    }

    @Override
    public boolean canDrop(ItemStack stack, Entity entity, IInventory inventory) {
        return true;
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, IInventory inventory) {
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
        if (entity.field_70173_aa % 20 == 0) {
            this.drainPower(stack, entity);
        }
    }
}

