/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.KeyBindRegistry;

public class ItemLurkerSkinPouch
extends Item
implements IEquippable {
    public ItemLurkerSkinPouch() {
        this.func_77625_d(1);
        this.func_77637_a(BLCreativeTabs.ITEMS);
        this.func_77656_e(3);
        this.func_185043_a(new ResourceLocation("pouch_size"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return stack.func_77952_i();
            }
        });
        IEquippable.addEquippedPropertyOverrides(this);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean showAdvancedInfo) {
        int slots = 9 + stack.func_77952_i() * 9;
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.lurkerSkinPouch.size", (Object[])new Object[]{slots}));
        list.add(I18n.func_135052_a((String)"tooltip.lurkerSkinPouch.usage", (Object[])new Object[]{KeyBindRegistry.OPEN_POUCH.getDisplayName()}));
        if (stack.func_77952_i() < stack.func_77958_k()) {
            list.add(I18n.func_135052_a((String)"tooltip.lurkerSkinPouch.upgrade", (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                int meta = stack.func_77952_i();
                player.openGui((Object)TheBetweenlands.INSTANCE, 11, world, meta, 0, 0);
            } else {
                player.openGui((Object)TheBetweenlands.INSTANCE, 13, world, hand == EnumHand.MAIN_HAND ? 0 : 1, 0, 0);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static ItemStack getFirstPouch(EntityPlayer player) {
        if (player.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
            IEquipmentCapability cap = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            IInventory inv = cap.getInventory(EnumEquipmentInventory.POUCH);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ItemRegistry.LURKER_SKIN_POUCH) continue;
                return stack;
            }
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            ItemStack stack = playerInventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != ItemRegistry.LURKER_SKIN_POUCH) continue;
            return stack;
        }
        return null;
    }

    @Override
    public EnumEquipmentInventory getEquipmentCategory(ItemStack stack) {
        return EnumEquipmentInventory.POUCH;
    }

    @Override
    public boolean canEquipOnRightClick(ItemStack stack, EntityPlayer player, Entity target) {
        return false;
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityPlayer player, Entity target) {
        return target == player;
    }

    @Override
    public boolean canUnequip(ItemStack stack, EntityPlayer player, Entity target, IInventory inventory) {
        return true;
    }

    @Override
    public boolean canDrop(ItemStack stack, Entity entity, IInventory inventory) {
        return true;
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, IInventory inventory) {
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
    }
}

