/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.ICircleGemCapability;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.client.handler.WorldRenderHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.capability.circlegem.CircleGem;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.capability.equipment.EquipmentHelper;
import thebetweenlands.common.entity.mobs.EntityGiantToad;
import thebetweenlands.common.entity.mobs.EntityTarminion;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.LightingUtil;
import thebetweenlands.util.NBTHelper;

public class ItemAmulet
extends Item
implements IEquippable {
    public static final List<Class<? extends EntityLivingBase>> SUPPORTED_ENTITIES = new ArrayList<Class<? extends EntityLivingBase>>();

    public ItemAmulet() {
        this.func_77637_a(BLCreativeTabs.SPECIALS);
        this.func_77625_d(1);
        CircleGemHelper.addGemPropertyOverrides(this);
        IEquippable.addEquippedPropertyOverrides(this);
    }

    public static boolean addAmulet(CircleGemType gem, Entity entity, boolean canUnequip, boolean canDrop) {
        ItemStack amulet = ItemAmulet.createStack(gem);
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(amulet);
        nbt.func_74757_a("canUnequip", canUnequip);
        nbt.func_74757_a("canDrop", canDrop);
        ItemStack result = EquipmentHelper.equipItem(null, entity, amulet, false);
        return result == null || result.field_77994_a != amulet.field_77994_a;
    }

    public static ItemStack createStack(CircleGemType gem) {
        ItemStack stack = new ItemStack(ItemRegistry.AMULET);
        CircleGemHelper.setGem(stack, gem);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(ItemAmulet.createStack(CircleGemType.NONE));
        list.add(ItemAmulet.createStack(CircleGemType.AQUA));
        list.add(ItemAmulet.createStack(CircleGemType.CRIMSON));
        list.add(ItemAmulet.createStack(CircleGemType.GREEN));
    }

    @Override
    public EnumEquipmentInventory getEquipmentCategory(ItemStack stack) {
        return EnumEquipmentInventory.AMULET;
    }

    @Override
    public boolean canEquipOnRightClick(ItemStack stack, EntityPlayer player, Entity target) {
        return true;
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityPlayer player, Entity target) {
        return CircleGemHelper.getGem(stack) != CircleGemType.NONE && (target instanceof EntityPlayer || SUPPORTED_ENTITIES.contains(target.getClass()) || player == null);
    }

    @Override
    public boolean canUnequip(ItemStack stack, EntityPlayer player, Entity target, IInventory inventory) {
        return target == player || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("canUnequip") || stack.func_77978_p().func_74767_n("canUnequip");
    }

    @Override
    public boolean canDrop(ItemStack stack, Entity entity, IInventory inventory) {
        return stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("canDrop") || stack.func_77978_p().func_74767_n("canDrop");
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, IInventory inventory) {
        if (entity.hasCapability(CapabilityRegistry.CAPABILITY_ENTITY_CIRCLE_GEM, null)) {
            ICircleGemCapability cap = (ICircleGemCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CIRCLE_GEM, null);
            cap.addGem(new CircleGem(CircleGemHelper.getGem(stack), CircleGem.CombatType.BOTH));
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
        if (entity.hasCapability(CapabilityRegistry.CAPABILITY_ENTITY_CIRCLE_GEM, null)) {
            ICircleGemCapability cap = (ICircleGemCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CIRCLE_GEM, null);
            List<CircleGem> gems = cap.getGems();
            CircleGemType type = CircleGemHelper.getGem(stack);
            for (CircleGem gem : gems) {
                if (gem.getCombatType() != CircleGem.CombatType.BOTH || gem.getGemType() != type) continue;
                cap.removeGem(gem);
                break;
            }
        }
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLiving(RenderLivingEvent.Specials.Post<EntityLivingBase> event) {
        if (event.getEntity() != null) {
            ItemAmulet.renderAmulet(event.getEntity(), event.getX(), event.getY(), event.getZ(), WorldRenderHandler.getPartialTicks());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderAmulet(EntityLivingBase entity, double x, double y, double z, float partialTicks) {
        if (entity.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
            IEquipmentCapability cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            IInventory inv = cap.getInventory(EnumEquipmentInventory.AMULET);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(inv.func_70302_i_());
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || CircleGemHelper.getGem(stack) == CircleGemType.NONE) continue;
                items.add(stack);
            }
            int amulets = items.size();
            float degOffset = 360.0f / (float)amulets;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            ITextureObject texture = textureManager.func_110581_b(TextureMap.field_110575_b);
            texture.func_174936_b(false, false);
            int i = 0;
            for (ItemStack stack : items) {
                GlStateManager.func_179114_b((float)degOffset, (float)0.0f, (float)1.0f, (float)0.0f);
                CircleGemType gem = CircleGemHelper.getGem(stack);
                ItemStack gemItem = null;
                switch (gem) {
                    case CRIMSON: {
                        gemItem = new ItemStack(ItemRegistry.CRIMSON_MIDDLE_GEM);
                        break;
                    }
                    case AQUA: {
                        gemItem = new ItemStack(ItemRegistry.AQUA_MIDDLE_GEM);
                        break;
                    }
                    case GREEN: {
                        gemItem = new ItemStack(ItemRegistry.GREEN_MIDDLE_GEM);
                        break;
                    }
                }
                if (gemItem == null) continue;
                IBakedModel model = renderItem.func_175037_a().func_178089_a(gemItem);
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(((float)entity.field_70173_aa + partialTicks) * 1.5f), (float)0.0f, (float)1.0f, (float)0.0f);
                double eyeHeight = entity.func_70047_e();
                GlStateManager.func_179137_b((double)0.0, (double)(eyeHeight / 1.5 + Math.sin((double)((float)entity.field_70173_aa + partialTicks) / 60.0 + (double)i / (double)amulets * Math.PI * 2.0) / 2.0 * (double)entity.field_70131_O / 4.0), (double)((double)entity.field_70130_N / 1.25));
                GlStateManager.func_179139_a((double)((double)(0.25f * entity.field_70131_O) / 2.0), (double)((double)(0.25f * entity.field_70131_O) / 2.0), (double)((double)(0.25f * entity.field_70131_O) / 2.0));
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                LightingUtil.INSTANCE.setLighting(255);
                renderItem.func_180454_a(stack, model);
                LightingUtil.INSTANCE.revert();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                float scale = ((float)Math.cos((float)entity.field_70173_aa / 5.0f) + 1.0f) / 15.0f + 1.05f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                renderItem.func_180454_a(stack, model);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                renderItem.func_180454_a(stack, model);
                GlStateManager.func_179121_F();
                ++i;
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            texture.func_174935_a();
        }
    }

    static {
        SUPPORTED_ENTITIES.add(EntityTarminion.class);
        SUPPORTED_ENTITIES.add(EntityGiantToad.class);
    }
}

