/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor;

import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.circlegem.CircleGemType;

public class ItemBLArmor
extends ItemArmor {
    protected final String armorTexture1;
    protected final String armorTexture2;
    protected final String[][] gemArmorTextures = new String[CircleGemType.values().length][2];
    protected final String armorName;

    public ItemBLArmor(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, String armorName) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.armorName = armorName;
        this.armorTexture1 = "thebetweenlands:textures/armor/" + armorName + "_1.png";
        this.armorTexture2 = "thebetweenlands:textures/armor/" + armorName + "_2.png";
        CircleGemHelper.addGemPropertyOverrides((Item)this);
    }

    public ItemBLArmor setGemArmorTextureOverride(CircleGemType type, String armorName) {
        this.gemArmorTextures[type.ordinal()][0] = "thebetweenlands:textures/armor/" + armorName + "_1.png";
        this.gemArmorTextures[type.ordinal()][1] = "thebetweenlands:textures/armor/" + armorName + "_2.png";
        return this;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String texture1 = this.armorTexture1;
        String texture2 = this.armorTexture2;
        CircleGemType gem = CircleGemHelper.getGem(stack);
        if (this.gemArmorTextures[gem.ordinal()][0] != null) {
            texture1 = this.gemArmorTextures[gem.ordinal()][0];
        }
        if (this.gemArmorTextures[gem.ordinal()][1] != null) {
            texture2 = this.gemArmorTextures[gem.ordinal()][1];
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            return texture2;
        }
        return texture1;
    }
}

