/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.inventory;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import thebetweenlands.api.event.EquipmentChangedEvent;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.common.capability.equipment.EquipmentEntityCapability;

public class InventoryEquipment
implements IInventory,
ITickable {
    protected final ItemStack[] inventory;
    protected final ItemStack[] prevTickStacks;
    protected final EquipmentEntityCapability capability;

    public InventoryEquipment(EquipmentEntityCapability capability, ItemStack[] inventory) {
        this.capability = capability;
        this.inventory = inventory;
        this.prevTickStacks = new ItemStack[inventory.length];
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            this.prevTickStacks[i] = stack == null ? null : stack.func_77946_l();
        }
    }

    public String func_70005_c_() {
        return "container.betweenlands.equipment";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        ItemStack stack = null;
        if (index < this.func_70302_i_()) {
            stack = ItemStackHelper.func_188383_a((ItemStack[])this.inventory, (int)index);
            this.func_70296_d();
        }
        return stack;
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = null;
        if (index < this.func_70302_i_()) {
            stack = ItemStackHelper.func_188382_a((ItemStack[])this.inventory, (int)index, (int)count);
            this.func_70296_d();
        }
        return stack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        if (index < this.func_70302_i_()) {
            this.inventory[index] = stack;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.capability.markDirty();
        MinecraftForge.EVENT_BUS.post((Event)new EquipmentChangedEvent((Entity)this.capability.getEntity(), this.capability));
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index < this.func_70302_i_();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return index >= this.func_70302_i_() ? null : this.inventory[index];
    }

    public void func_73660_a() {
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null || !(stack.func_77973_b() instanceof IEquippable)) continue;
            ((IEquippable)stack.func_77973_b()).onEquipmentTick(stack, (Entity)this.capability.getEntity(), this);
        }
        this.detectChangesAndMarkDirty();
    }

    protected void detectChangesAndMarkDirty() {
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack prevStack = this.prevTickStacks[i];
            ItemStack stack = this.inventory[i];
            if (ItemStack.func_77989_b((ItemStack)prevStack, (ItemStack)stack)) continue;
            this.prevTickStacks[i] = stack == null ? null : stack.func_77946_l();
            prevStack = this.prevTickStacks[i];
            this.func_70296_d();
        }
    }
}

