/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.elixir.effects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElixirEffect {
    private final String effectName;
    private final int effectID;
    private final ResourceLocation icon;
    private final int color;
    private List<ElixirAttributeModifier> elixirAttributeModifiers = new ArrayList<ElixirAttributeModifier>();
    private ElixirPotionEffect potionEffect;
    private ResourceLocation potionID;
    private boolean isAntiInfusion = false;

    public ElixirEffect(int id, String name) {
        this(id, name, null, 0);
    }

    public ElixirEffect(int id, String name, ResourceLocation icon) {
        this(id, name, icon, 0);
    }

    public ElixirEffect(int id, String name, int color) {
        this(id, name, null, color);
    }

    public ElixirEffect(int id, String name, ResourceLocation icon, int color) {
        this.effectID = id;
        this.effectName = name;
        this.icon = icon;
        this.color = color;
    }

    public PotionEffect createEffect(int duration, int strength) {
        return new PotionEffect(Potion.func_180142_b((String)this.potionID.toString()), duration, strength);
    }

    public void registerPotion() {
        this.potionID = null;
        this.potionEffect = new ElixirPotionEffect(this, this.effectName, this.color, this.icon);
        Potion.field_188414_b.func_177775_a(this.getID(), (Object)this.potionID, (Object)this.potionEffect);
        for (ElixirAttributeModifier modifier : this.elixirAttributeModifiers) {
            this.potionEffect.func_111184_a(modifier.attribute, modifier.uuid.toString(), modifier.modifier, modifier.operation);
        }
    }

    public int getID() {
        return this.effectID;
    }

    public String getEffectName() {
        return this.effectName;
    }

    public ResourceLocation getIcon() {
        return this.potionEffect.icon;
    }

    protected boolean isReady(int ticks, int strength) {
        return true;
    }

    protected void performEffect(EntityLivingBase entity, int strength) {
    }

    protected void affectEntity(@Nullable Entity source, @Nullable Entity indirectSource, EntityLivingBase target, int amplifier, double health) {
    }

    protected boolean isInstant() {
        return false;
    }

    protected double getAttributeModifier(AttributeModifier attributeModifier, int strength) {
        return attributeModifier.func_111164_d() * (double)(strength + 1);
    }

    public ElixirEffect addAttributeModifier(IAttribute attribute, String uuid, double modifier, int operation) {
        if (this.potionEffect != null) {
            this.potionEffect.func_111184_a(attribute, uuid, modifier, operation);
        } else {
            this.elixirAttributeModifiers.add(new ElixirAttributeModifier(attribute, uuid, modifier, operation));
        }
        return this;
    }

    public ElixirEffect setAntiInfusion() {
        this.isAntiInfusion = true;
        return this;
    }

    public boolean isAntiInfusion() {
        return this.isAntiInfusion;
    }

    public boolean isActive(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        Collection activePotions = entity.func_70651_bq();
        for (PotionEffect effect : activePotions) {
            if (effect.func_188419_a().getRegistryName() != this.potionID) continue;
            return true;
        }
        return false;
    }

    public int getDuration(EntityLivingBase entity) {
        if (entity == null) {
            return -1;
        }
        Collection activePotions = entity.func_70651_bq();
        for (PotionEffect effect : activePotions) {
            if (effect.func_188419_a().getRegistryName() != this.potionID) continue;
            return effect.func_76459_b();
        }
        return -1;
    }

    public int getStrength(EntityLivingBase entity) {
        if (entity == null) {
            return -1;
        }
        Collection activePotions = entity.func_70651_bq();
        for (PotionEffect effect : activePotions) {
            if (effect.func_188419_a().getRegistryName() != this.potionID) continue;
            return effect.func_76458_c();
        }
        return -1;
    }

    public PotionEffect getPotionEffect(EntityLivingBase entity) {
        if (entity.func_70644_a(Potion.func_180142_b((String)this.potionID.toString()))) {
            return entity.func_70660_b((Potion)this.potionEffect);
        }
        return null;
    }

    public void removeElixir(EntityLivingBase entity) {
        entity.func_184589_d(Potion.func_180142_b((String)this.potionID.toString()));
    }

    public ElixirPotionEffect getPotionEffect() {
        return this.potionEffect;
    }

    public static class ElixirPotionEffect
    extends Potion {
        private final ElixirEffect effect;
        private final ResourceLocation icon;

        protected ElixirPotionEffect(ElixirEffect effect, String name, int color, ResourceLocation icon) {
            super(false, color);
            this.func_76390_b(name);
            this.effect = effect;
            this.icon = icon;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_76400_d() {
            return this.icon != null;
        }

        public boolean func_76403_b() {
            return this.effect.isInstant();
        }

        @SideOnly(value=Side.CLIENT)
        public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
            super.renderInventoryEffect(x, y, effect, mc);
        }

        public boolean func_76397_a(int ticks, int strength) {
            return this.effect.isReady(ticks, strength);
        }

        public void func_76394_a(EntityLivingBase entity, int strength) {
            this.effect.performEffect(entity, strength);
        }

        public void func_180793_a(@Nullable Entity source, @Nullable Entity indirectSource, EntityLivingBase target, int amplifier, double health) {
            this.effect.affectEntity(source, indirectSource, target, amplifier, health);
        }

        public double func_111183_a(int strength, AttributeModifier attributeModifier) {
            return this.effect.getAttributeModifier(attributeModifier, strength);
        }
    }

    private static class ElixirAttributeModifier {
        private final IAttribute attribute;
        private final String uuid;
        private final double modifier;
        private final int operation;

        private ElixirAttributeModifier(IAttribute attribute, String uuid, double modifier, int operation) {
            this.attribute = attribute;
            this.uuid = uuid;
            this.modifier = modifier;
            this.operation = operation;
        }
    }
}

