/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.book.GuiManualHerblore;
import thebetweenlands.common.herblore.book.ManualCategory;
import thebetweenlands.common.herblore.book.ManualManager;
import thebetweenlands.common.herblore.book.widgets.ManualWidgetBase;
import thebetweenlands.common.registries.ItemRegistry;

public class Page {
    public int pageNumber;
    public ArrayList<ItemStack> pageItems = new ArrayList();
    public ArrayList<IAspectType> pageAspects = new ArrayList();
    public String resourceLocation;
    public int xStartTexture = 0;
    public int xEndTexture = 0;
    public int yStartTexture = 0;
    public int yEndTexture = 0;
    public int textureWidth = 0;
    public int textureHeight = 0;
    public boolean isHidden = false;
    public String pageName;
    public String unlocalizedPageName;
    public String localizedPageName;
    public ArrayList<ManualWidgetBase> widgets = new ArrayList();
    public boolean rightPage = false;
    public ManualCategory parentCategory;
    public boolean isParent = false;

    public Page(String pageName, ArrayList<ManualWidgetBase> widgets, boolean isHidden, Item manualType) {
        this.widgets = widgets;
        this.pageName = I18n.func_74838_a((String)("manual." + pageName + ".title"));
        this.unlocalizedPageName = pageName;
        this.isHidden = isHidden;
        if (isHidden && manualType == ItemRegistry.MANUAL_HL) {
            ManualManager.findablePagesHL.add(pageName);
            ManualManager.findablePagesAll.add(pageName);
        }
    }

    public Page(String pageName, boolean isHidden, Item manualType, ManualWidgetBase ... widgets) {
        Collections.addAll(this.widgets, widgets);
        this.pageName = I18n.func_74838_a((String)("manual." + pageName + ".title"));
        this.unlocalizedPageName = pageName;
        this.isHidden = isHidden;
        if (isHidden && manualType == ItemRegistry.MANUAL_HL) {
            ManualManager.findablePagesHL.add(pageName);
            ManualManager.findablePagesAll.add(pageName);
        }
    }

    public void init(GuiManualHerblore manual) {
        for (ManualWidgetBase widget : this.widgets) {
            widget.init(manual);
        }
    }

    public Page setParent() {
        this.isParent = true;
        return this;
    }

    public Page addItems(ArrayList<ItemStack> items) {
        this.pageItems.addAll(items);
        return this;
    }

    public Page addItem(ItemStack item) {
        this.pageItems.add(item);
        return this;
    }

    public Page setAspect(IAspectType aspect) {
        this.pageAspects.add(aspect);
        return this;
    }

    public Page setAspects(IAspectType[] aspects) {
        Collections.addAll(this.pageAspects, aspects);
        return this;
    }

    public Page setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        this.rightPage = pageNumber % 2 == 0;
        return this;
    }

    public void setPageToRight() {
        for (ManualWidgetBase widget : this.widgets) {
            widget.setPageToRight();
        }
    }

    public void draw(int mouseX, int mouseY) {
        for (ManualWidgetBase widget : this.widgets) {
            widget.draw(mouseX, mouseY);
        }
        for (ManualWidgetBase widget : this.widgets) {
            widget.drawToolTip();
        }
    }

    public void keyTyped(char c, int key) {
        for (ManualWidgetBase widget : this.widgets) {
            widget.keyTyped(c, key);
        }
    }

    public void mouseClicked(int x, int y, int button) {
        for (ManualWidgetBase widget : this.widgets) {
            widget.mouseClicked(x, y, button);
        }
    }

    public void updateScreen() {
        for (ManualWidgetBase widget : this.widgets) {
            widget.updateScreen();
        }
    }

    public void resize() {
        for (ManualWidgetBase widget : this.widgets) {
            widget.resize();
        }
    }

    public Page setParentCategory(ManualCategory category) {
        this.parentCategory = category;
        return this;
    }

    public Page setLocalizedPageName(String text) {
        this.pageName = text;
        return this;
    }
}

