/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IPuppetCapability;
import thebetweenlands.api.capability.IPuppeteerCapability;
import thebetweenlands.client.handler.WorldRenderHandler;
import thebetweenlands.client.render.entity.RenderSwordEnergy;
import thebetweenlands.client.render.entity.layer.LayerPuppetOverlay;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.ai.EntityAIFollowTarget;
import thebetweenlands.common.entity.ai.puppet.EntityAIGoTo;
import thebetweenlands.common.entity.ai.puppet.EntityAIPuppet;
import thebetweenlands.common.entity.ai.puppet.EntityAIStay;
import thebetweenlands.common.item.equipment.ItemRingOfRecruitment;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.util.RenderHelper;

public class PuppetHandler {
    private PuppetHandler() {
    }

    @SubscribeEvent
    public static void onUpdateLiving(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityCreature && entity.hasCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) {
            IPuppetCapability cap = (IPuppetCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
            EntityCreature creature = (EntityCreature)entity;
            if (cap.hasPuppeteer()) {
                if (!entity.field_70170_p.field_72995_K) {
                    cap.setRemainingTicks(cap.getRemainingTicks() - 1);
                    if (cap.getRemainingTicks() <= 0 || cap.getPuppeteer() != null && !ItemRingOfRecruitment.isRingActive(cap.getPuppeteer())) {
                        cap.setPuppeteer(null);
                        cap.setRemainingTicks(0);
                        creature.func_70624_b(null);
                        creature.func_70604_c(null);
                        EntityAIPuppet.removePuppetAI(creature.field_70715_bh);
                    } else if (EntityAIPuppet.getPuppetAI(creature.field_70715_bh) == null) {
                        EntityAIStay aiStay = new EntityAIStay((EntityLiving)creature);
                        aiStay.func_75248_a(3);
                        EntityAIGoTo aiGoTo = new EntityAIGoTo((EntityLiving)creature, 1.2);
                        aiGoTo.func_75248_a(3);
                        EntityAIAttackMelee aiMelee = new EntityAIAttackMelee(creature, 1.2, true);
                        aiMelee.func_75248_a(2);
                        if (creature.func_70661_as() instanceof PathNavigateGround) {
                            EntityAIFollowTarget aiFollow = new EntityAIFollowTarget((EntityLiving)creature, () -> {
                                Entity puppeteer = cap.getPuppeteer();
                                if (puppeteer instanceof EntityLivingBase) {
                                    return (EntityLivingBase)puppeteer;
                                }
                                return null;
                            }, 1.2, 10.0f, 2.0f);
                            aiFollow.func_75248_a(1);
                            EntityAIPuppet.addPuppetAI(() -> cap.getPuppeteer(), (EntityLivingBase)creature, creature.field_70715_bh, (List<EntityAIBase>)ImmutableList.of((Object)((Object)aiStay), (Object)((Object)aiFollow), (Object)((Object)aiGoTo), (Object)aiMelee));
                        } else {
                            EntityAIPuppet.addPuppetAI(() -> cap.getPuppeteer(), (EntityLivingBase)creature, creature.field_70715_bh, (List<EntityAIBase>)ImmutableList.of((Object)((Object)aiStay), (Object)((Object)aiGoTo), (Object)aiMelee));
                        }
                    }
                } else if (entity.field_70170_p.field_73012_v.nextInt(5) == 0) {
                    BLParticles.SPAWNER.spawn(creature.field_70170_p, creature.field_70165_t + creature.field_70159_w * 2.0, creature.field_70163_u + (double)creature.field_70131_O / 2.0, creature.field_70161_v + creature.field_70179_y * 2.0, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(creature.field_70159_w + (double)((creature.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f * entity.field_70130_N), (creature.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f * entity.field_70131_O, creature.field_70179_y + (double)((creature.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f * entity.field_70130_N))).withData(40)).withColor(0.2f, 0.8f, 0.4f, 1.0f));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        IPuppeteerCapability cap;
        List<Entity> puppets;
        DamageSource source;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (!attackedEntity.field_70170_p.field_72995_K && (source = event.getSource()).func_76346_g() instanceof EntityPlayer && source.func_76346_g().hasCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null) && !(puppets = (cap = (IPuppeteerCapability)source.func_76346_g().getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)).getPuppets()).contains(attackedEntity)) {
            for (Entity entity : puppets) {
                if (!(entity instanceof EntityLiving)) continue;
                ((EntityLiving)entity).func_70624_b(attackedEntity);
            }
        }
    }

    private static <T extends EntityAIBase> T getAI(Class<T> cls, EntityAITasks tasks) {
        for (EntityAITasks.EntityAITaskEntry entry : tasks.field_75782_a) {
            if (cls != entry.field_75733_a.getClass()) continue;
            return (T)entry.field_75733_a;
        }
        return null;
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        if (event.getHand() == EnumHand.MAIN_HAND && player != null && target instanceof EntityCreature && ItemRingOfRecruitment.isRingActive((Entity)player) && target.hasCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) {
            IPuppeteerCapability capPlayer;
            IPuppetCapability cap = (IPuppetCapability)target.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
            EntityCreature creature = (EntityCreature)target;
            if (cap.hasPuppeteer()) {
                Entity puppeteer = cap.getPuppeteer();
                if (player == puppeteer) {
                    if (player.func_70093_af()) {
                        if (!player.field_70170_p.field_72995_K) {
                            cap.setRemainingTicks(0);
                        }
                        player.func_184609_a(EnumHand.MAIN_HAND);
                    } else {
                        EntityAIStay aiStay;
                        EntityAIPuppet puppetAI;
                        if (!player.field_70170_p.field_72995_K && (puppetAI = EntityAIPuppet.getPuppetAI(creature.field_70715_bh)) != null && (aiStay = PuppetHandler.getAI(EntityAIStay.class, puppetAI.getSubTasks())) != null) {
                            aiStay.setStay(!aiStay.getStay());
                            creature.func_70624_b(null);
                        }
                        player.func_184609_a(EnumHand.MAIN_HAND);
                    }
                }
            } else if (!player.field_70170_p.field_72995_K && ItemRingOfRecruitment.isRingActive((Entity)player) && player.hasCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null) && (capPlayer = (IPuppeteerCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)).getActivatingEntity() == null) {
                capPlayer.setActivatingEntity((Entity)creature);
                capPlayer.setActivatingTicks(0);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        IPuppeteerCapability cap;
        Entity activatingEntity;
        if (event.phase == TickEvent.Phase.END && event.player.hasCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null) && (activatingEntity = (cap = (IPuppeteerCapability)event.player.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)).getActivatingEntity()) instanceof EntityCreature) {
            EntityCreature creature = (EntityCreature)activatingEntity;
            if (!event.player.field_70170_p.field_72995_K) {
                if ((double)creature.func_70032_d((Entity)event.player) > 5.0) {
                    cap.setActivatingEntity(null);
                    cap.setActivatingTicks(0);
                } else {
                    cap.setActivatingTicks(cap.getActivatingTicks() + 1);
                    if ((float)cap.getActivatingTicks() > creature.func_110138_aP()) {
                        IPuppetCapability puppetCap;
                        if (ItemRingOfRecruitment.isRingActive((Entity)event.player) && creature.hasCapability(CapabilityRegistry.CAPABILITY_PUPPET, null) && (puppetCap = (IPuppetCapability)creature.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)).getPuppeteer() == null) {
                            puppetCap.setPuppeteer((Entity)event.player);
                            puppetCap.setRemainingTicks(12000);
                        }
                        cap.setActivatingEntity(null);
                        cap.setActivatingTicks(0);
                    }
                }
            } else {
                Vec3d vec = new Vec3d(creature.field_70165_t - event.player.field_70165_t, creature.field_70163_u + (double)(creature.func_70047_e() * 0.8f) - (event.player.field_70163_u + (double)(event.player.func_70047_e() * 0.8f)), creature.field_70161_v - event.player.field_70161_v);
                vec = vec.func_72432_b();
                vec = vec.func_72441_c((double)((event.player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 3.0f), (double)((event.player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 3.0f), (double)((event.player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 3.0f));
                vec = vec.func_72432_b();
                double dist = event.player.func_70032_d((Entity)creature);
                vec = vec.func_186678_a(dist / 15.0);
                BLParticles.SPAWNER.spawn(event.player.field_70170_p, event.player.field_70165_t, event.player.field_70163_u + (double)(event.player.func_70047_e() * 0.8f), event.player.field_70161_v, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(40)).withColor(0.2f, 0.8f, 0.4f, 1.0f)).withMotion(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
            }
            event.player.field_70159_w *= 0.05;
            event.player.field_70179_y *= 0.05;
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        EntityPlayer player;
        if (event.getHand() == EnumHand.MAIN_HAND && event instanceof PlayerInteractEvent.RightClickBlock && ItemRingOfRecruitment.isRingActive((Entity)event.getEntityPlayer()) && (player = event.getEntityPlayer()).hasCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) {
            IPuppeteerCapability cap = (IPuppeteerCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null);
            List<Entity> puppets = cap.getPuppets();
            BlockPos target = event.getPos().func_177972_a(event.getFace());
            boolean ordered = false;
            for (Entity puppet : puppets) {
                if (!(puppet instanceof EntityLiving)) continue;
                EntityLiving living = (EntityLiving)puppet;
                if (!player.field_70170_p.field_72995_K) {
                    EntityAIGoTo aiGoTo;
                    EntityAIPuppet puppetAI = EntityAIPuppet.getPuppetAI(living.field_70715_bh);
                    if (puppetAI != null && (aiGoTo = PuppetHandler.getAI(EntityAIGoTo.class, puppetAI.getSubTasks())) != null) {
                        aiGoTo.setTarget(target);
                    }
                    living.func_70624_b(null);
                }
                ordered = true;
            }
            if (ordered) {
                player.func_184609_a(EnumHand.MAIN_HAND);
                if (player.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 4; ++i) {
                        BLParticles.SPAWNER.spawn(player.field_70170_p, (double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f, (player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f, (player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f)).withData(30)).withColor(0.2f, 0.8f, 0.25f, 1.0f));
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLivingPre(RenderLivingEvent.Pre<EntityLivingBase> event) {
        IPuppetCapability cap;
        EntityLivingBase living = event.getEntity();
        if (living.hasCapability(CapabilityRegistry.CAPABILITY_PUPPET, null) && (cap = (IPuppetCapability)living.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)).hasPuppeteer() && !RenderHelper.doesRendererHaveLayer(event.getRenderer(), LayerPuppetOverlay.class, false)) {
            event.getRenderer().func_177094_a((LayerRenderer)new LayerPuppetOverlay((RenderLivingBase<EntityLivingBase>)event.getRenderer()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLivingPost(RenderLivingEvent.Post<EntityLivingBase> event) {
        Entity puppeteer;
        IPuppetCapability cap;
        EntityLivingBase living = event.getEntity();
        if (living.hasCapability(CapabilityRegistry.CAPABILITY_PUPPET, null) && (cap = (IPuppetCapability)living.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)).hasPuppeteer() && (puppeteer = cap.getPuppeteer()) != null) {
            event.getRenderer().func_110776_a(LayerPuppetOverlay.OVERLAY_TEXTURE);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)(((float)living.field_70173_aa + WorldRenderHandler.getPartialTicks()) / 40.0f), (float)0.0f, (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179098_w();
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)false);
            double dx = puppeteer.field_70142_S + (puppeteer.field_70165_t - puppeteer.field_70142_S) * (double)WorldRenderHandler.getPartialTicks() - (living.field_70142_S + (living.field_70165_t - living.field_70142_S) * (double)WorldRenderHandler.getPartialTicks());
            double dy = (double)(-living.field_70131_O / 2.0f) + (double)puppeteer.field_70131_O / 2.0 + puppeteer.field_70137_T + (puppeteer.field_70163_u - puppeteer.field_70137_T) * (double)WorldRenderHandler.getPartialTicks() - (living.field_70137_T + (living.field_70163_u - living.field_70137_T) * (double)WorldRenderHandler.getPartialTicks());
            double dz = puppeteer.field_70136_U + (puppeteer.field_70161_v - puppeteer.field_70136_U) * (double)WorldRenderHandler.getPartialTicks() - (living.field_70136_U + (living.field_70161_v - living.field_70136_U) * (double)WorldRenderHandler.getPartialTicks());
            double sx = event.getX();
            double sy = event.getY() + (double)(living.field_70131_O / 2.0f);
            double sz = event.getZ();
            float sw = 0.03f;
            float ew = 0.01f;
            double ticks = ((float)living.field_70173_aa + WorldRenderHandler.getPartialTicks()) / 5.0f;
            double prevXOffset = 0.0;
            double prevYOffset = 0.0;
            double prevZOffset = 0.0;
            int iter = Minecraft.func_71375_t() ? 8 : 4;
            for (int i = 0; i < iter; ++i) {
                double multiplier = (1.0 - Math.abs((double)(i + 1) - (double)iter / 2.0) / (double)iter * 2.0) * 0.15;
                double xOffset = Math.cos((double)((float)(i + 1) * 4.0f / (float)iter) + ticks) * multiplier;
                double yOffset = Math.cos((double)((float)(i + 1) * 4.0f / (float)iter) + ticks + Math.PI) * multiplier;
                double zOffset = Math.sin((double)((float)(i + 1) * 4.0f / (float)iter) + ticks) * multiplier;
                RenderSwordEnergy.renderBeam(new Vec3d(sx + prevXOffset + dx / (double)iter * (double)i, sy + prevYOffset + dy / (double)iter * (double)i, sz + prevZOffset + dz / (double)iter * (double)i), new Vec3d(sx + xOffset + dx / (double)iter * (double)(i + 1), sy + yOffset + dy / (double)iter * (double)(i + 1), sz + zOffset + dz / (double)iter * (double)(i + 1)), ew + sw - sw / (float)iter * (float)i, ew + sw - sw / (float)iter * (float)(i + 1), i == 0, i == iter - 1);
                prevXOffset = xOffset;
                prevYOffset = yOffset;
                prevZOffset = zOffset;
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179089_o();
            GlStateManager.func_179098_w();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }
}

